/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.servo.Metric;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.publish.JmxConnector;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.publish.MetricPoller;
import com.netflix.servo.tag.BasicTag;
import com.netflix.servo.tag.SortedTagList;
import com.netflix.servo.tag.StandardTagKeys;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmxMetricPoller
implements MetricPoller {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxMetricPoller.class);
    private static final Tag CLASS_TAG = new BasicTag(StandardTagKeys.CLASS_NAME.getKeyName(), JmxMetricPoller.class.getCanonicalName());
    private static final String DOMAIN_KEY = "JmxDomain";
    private static final String COMPOSITE_PATH_KEY = "JmxCompositePath";
    private static final String PROP_KEY_PREFIX = "Jmx";
    private final JmxConnector connector;
    private final ObjectName query;
    private final MetricFilter counters;

    public JmxMetricPoller(JmxConnector jmxConnector, ObjectName objectName, MetricFilter metricFilter) {
        this.connector = jmxConnector;
        this.query = objectName;
        this.counters = metricFilter;
    }

    private TagList createTagList(ObjectName objectName) {
        Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
        ArrayList arrayList = Lists.newArrayList();
        for (Map.Entry entry : hashtable.entrySet()) {
            String string = "Jmx." + (String)entry.getKey();
            arrayList.add(new BasicTag(string, (String)entry.getValue()));
        }
        arrayList.add(new BasicTag(DOMAIN_KEY, objectName.getDomain()));
        arrayList.add(CLASS_TAG);
        return SortedTagList.builder().withTags(arrayList).build();
    }

    private void addMetric(List<Metric> list, String string, TagList tagList, Object object) {
        long l = System.currentTimeMillis();
        Number number = JmxMetricPoller.asNumber(object);
        if (number != null) {
            SortedTagList sortedTagList = this.counters.matches(MonitorConfig.builder(string).withTags(tagList).build()) ? SortedTagList.builder().withTags(tagList).withTag(DataSourceType.COUNTER).build() : SortedTagList.builder().withTags(tagList).withTag(DataSourceType.GAUGE).build();
            Metric metric = new Metric(string, sortedTagList, l, number);
            list.add(metric);
        }
    }

    private void extractValues(String string, Map<String, Object> map, CompositeData compositeData) {
        for (String string2 : compositeData.getCompositeType().keySet()) {
            String string3 = string == null ? string2 : string + "." + string2;
            Object object = compositeData.get(string2);
            if (object instanceof CompositeData) {
                this.extractValues(string3, map, (CompositeData)object);
                continue;
            }
            if (object == null) continue;
            map.put(string3, object);
        }
    }

    private void getMetrics(MBeanServerConnection mBeanServerConnection, MetricFilter metricFilter, List<Metric> list, ObjectName objectName) throws JMException, IOException {
        TagList tagList = this.createTagList(objectName);
        MBeanInfo mBeanInfo = mBeanServerConnection.getMBeanInfo(objectName);
        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
        if (mBeanAttributeInfoArray == null) {
            return;
        }
        ArrayList arrayList = Lists.newArrayList();
        for (MBeanAttributeInfo mBeanAttributeInfo : mBeanAttributeInfoArray) {
            String object = mBeanAttributeInfo.getName();
            if (!metricFilter.matches(new MonitorConfig.Builder(object).withTags(tagList).build())) continue;
            arrayList.add(object);
        }
        int n = arrayList.size();
        String[] stringArray = arrayList.toArray(new String[n]);
        AttributeList attributeList = mBeanServerConnection.getAttributes(objectName, stringArray);
        for (Attribute attribute : attributeList.asList()) {
            String string = attribute.getName();
            Object object = attribute.getValue();
            if (object instanceof CompositeData) {
                HashMap hashMap = Maps.newHashMap();
                this.extractValues(null, hashMap, (CompositeData)object);
                for (Map.Entry entry : hashMap.entrySet()) {
                    String string2 = (String)entry.getKey();
                    SortedTagList sortedTagList = SortedTagList.builder().withTags(tagList).withTag(COMPOSITE_PATH_KEY, string2).build();
                    if (!metricFilter.matches(MonitorConfig.builder(string).withTags(sortedTagList).build())) continue;
                    this.addMetric(list, string, sortedTagList, entry.getValue());
                }
                continue;
            }
            this.addMetric(list, string, tagList, object);
        }
    }

    private static Number asNumber(Object object) {
        Number number = null;
        if (object == null) {
            number = null;
        } else if (object instanceof Number) {
            number = (Number)object;
        } else if (object instanceof Boolean) {
            number = (Boolean)object != false ? 1 : 0;
        }
        return number;
    }

    @Override
    public List<Metric> poll(MetricFilter metricFilter) {
        return this.poll(metricFilter, false);
    }

    @Override
    public List<Metric> poll(MetricFilter metricFilter, boolean bl) {
        ArrayList arrayList = Lists.newArrayList();
        try {
            MBeanServerConnection mBeanServerConnection = this.connector.getConnection();
            Set<ObjectName> set = mBeanServerConnection.queryNames(this.query, null);
            for (ObjectName objectName : set) {
                try {
                    this.getMetrics(mBeanServerConnection, metricFilter, arrayList, objectName);
                }
                catch (JMException jMException) {
                    LOGGER.warn("failed to get metrics for: " + objectName, (Throwable)jMException);
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.warn("failed to collect jmx metrics matching: " + this.query, (Throwable)iOException);
        }
        return arrayList;
    }
}

