/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.servo.Metric;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.publish.MetricPoller;
import com.netflix.servo.publish.PollCallable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeMetricPoller
implements MetricPoller {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeMetricPoller.class);
    private static final List<Metric> EMPTY = ImmutableList.of();
    private static final String POLLER_KEY = "PollerName";
    private final Map<String, MetricPoller> pollers;
    private final ExecutorService executor;
    private final long timeout;

    public CompositeMetricPoller(Map<String, MetricPoller> map, ExecutorService executorService, long l) {
        this.pollers = ImmutableMap.copyOf(map);
        this.executor = executorService;
        this.timeout = l;
    }

    private void increment(Throwable throwable, String string) {
    }

    private List<Metric> getMetrics(String string, Future<List<Metric>> future) {
        List<Metric> list = EMPTY;
        try {
            list = future.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            this.increment(executionException, string);
            LOGGER.warn("uncaught exception from poll method for {}", (Object)executionException, (Object)string);
        }
        catch (TimeoutException timeoutException) {
            this.increment(timeoutException, string);
            LOGGER.warn("timeout executing poll method for {}", (Object)timeoutException, (Object)string);
        }
        catch (InterruptedException interruptedException) {
            this.increment(interruptedException, string);
            LOGGER.warn("interrupted while doing get for {}", (Object)interruptedException, (Object)string);
        }
        return list;
    }

    @Override
    public final List<Metric> poll(MetricFilter metricFilter) {
        return this.poll(metricFilter, false);
    }

    @Override
    public final List<Metric> poll(MetricFilter metricFilter, boolean bl) {
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry<String, MetricPoller> object : this.pollers.entrySet()) {
            PollCallable pollCallable = new PollCallable(object.getValue(), metricFilter, bl);
            hashMap.put(object.getKey(), this.executor.submit(pollCallable));
        }
        ArrayList arrayList = Lists.newArrayList();
        for (Map.Entry entry : hashMap.entrySet()) {
            arrayList.addAll(this.getMetrics((String)entry.getKey(), (Future)entry.getValue()));
        }
        return arrayList;
    }
}

