/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.collect.Lists;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.MonitorTags;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.AnnotatedNumberMonitor;
import com.netflix.servo.monitor.AnnotatedStringMonitor;
import com.netflix.servo.monitor.BasicCompositeMonitor;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.BasicTimer;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.CompositeMonitorWrapper;
import com.netflix.servo.monitor.ContextualCounter;
import com.netflix.servo.monitor.ContextualTimer;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.MonitorWrapper;
import com.netflix.servo.monitor.MonitoredCache;
import com.netflix.servo.monitor.MonitoredThreadPool;
import com.netflix.servo.monitor.NumericMonitor;
import com.netflix.servo.monitor.NumericMonitorWrapper;
import com.netflix.servo.monitor.Timer;
import com.netflix.servo.tag.SortedTagList;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.tag.TaggingContext;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class Monitors {
    private static final String DEFAULT_ID = "default";
    private static final CounterFactory COUNTER_FUNCTION = new CounterFactory();

    private Monitors() {
    }

    public static Timer newTimer(String string) {
        return Monitors.newTimer(string, TimeUnit.MILLISECONDS);
    }

    public static Timer newTimer(String string, TaggingContext taggingContext) {
        return Monitors.newTimer(string, TimeUnit.MILLISECONDS, taggingContext);
    }

    public static Timer newTimer(String string, TimeUnit timeUnit) {
        return new BasicTimer(MonitorConfig.builder(string).build(), timeUnit);
    }

    public static Timer newTimer(String string, TimeUnit timeUnit, TaggingContext taggingContext) {
        MonitorConfig monitorConfig = MonitorConfig.builder(string).build();
        return new ContextualTimer(monitorConfig, taggingContext, new TimerFactory(timeUnit));
    }

    public static Counter newCounter(String string) {
        return new BasicCounter(MonitorConfig.builder(string).build());
    }

    public static Counter newCounter(String string, TaggingContext taggingContext) {
        MonitorConfig monitorConfig = MonitorConfig.builder(string).build();
        return new ContextualCounter(monitorConfig, taggingContext, COUNTER_FUNCTION);
    }

    public static CompositeMonitor<?> newObjectMonitor(Object object) {
        return Monitors.newObjectMonitor(null, object);
    }

    public static CompositeMonitor<?> newObjectMonitor(String string, Object object) {
        TagList tagList = Monitors.getMonitorTags(object);
        ArrayList arrayList = Lists.newArrayList();
        Monitors.addMonitors(arrayList, string, tagList, object);
        Class<?> clazz = object.getClass();
        String string2 = string == null ? DEFAULT_ID : string;
        return new BasicCompositeMonitor(Monitors.newObjectConfig(clazz, string2, tagList), arrayList);
    }

    public static CompositeMonitor<?> newThreadPoolMonitor(String string, ThreadPoolExecutor threadPoolExecutor) {
        return Monitors.newObjectMonitor(string, new MonitoredThreadPool(threadPoolExecutor));
    }

    public static CompositeMonitor<?> newCacheMonitor(String string, Cache<?, ?> cache) {
        return Monitors.newObjectMonitor(string, new MonitoredCache(cache));
    }

    public static void registerObject(Object object) {
        Monitors.registerObject(null, object);
    }

    public static void registerObject(String string, Object object) {
        DefaultMonitorRegistry.getInstance().register(Monitors.newObjectMonitor(string, object));
    }

    static <T> Monitor<T> wrap(TagList tagList, Monitor<T> monitor) {
        AbstractMonitor abstractMonitor = null;
        abstractMonitor = monitor instanceof CompositeMonitor ? new CompositeMonitorWrapper(tagList, (CompositeMonitor)monitor) : (monitor instanceof NumericMonitor ? new NumericMonitorWrapper(tagList, (NumericMonitor)monitor) : new MonitorWrapper<T>(tagList, monitor));
        return abstractMonitor;
    }

    static void addMonitors(List<Monitor<?>> list, String string, TagList tagList, Object object) {
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Monitors.addMonitorFields(list, string, tagList, object, clazz);
            Monitors.addAnnotatedFields(list, string, tagList, object, clazz);
        }
    }

    static void addMonitorFields(List<Monitor<?>> list, String string, TagList tagList, Object object, Class<?> clazz) {
        try {
            Field[] fieldArray;
            SortedTagList.Builder builder = SortedTagList.builder();
            builder.withTag("class", object.getClass().getSimpleName());
            if (tagList != null) {
                builder.withTags(tagList);
            }
            if (string != null) {
                builder.withTag("id", string);
            }
            SortedTagList sortedTagList = builder.build();
            for (Field field : fieldArray = clazz.getDeclaredFields()) {
                if (!Monitors.isMonitorType(field.getType())) continue;
                field.setAccessible(true);
                list.add(Monitors.wrap(sortedTagList, (Monitor)field.get(object)));
            }
        }
        catch (Exception exception) {
            throw Throwables.propagate((Throwable)exception);
        }
    }

    static void addAnnotatedFields(List<Monitor<?>> list, String string, TagList tagList, Object object, Class<?> clazz) {
        Class<com.netflix.servo.annotations.Monitor> clazz2 = com.netflix.servo.annotations.Monitor.class;
        try {
            Object object2;
            Field[] fieldArray = clazz.getDeclaredFields();
            AccessibleObject[] accessibleObjectArray = fieldArray;
            int n = accessibleObjectArray.length;
            for (int i = 0; i < n; ++i) {
                Field field = accessibleObjectArray[i];
                com.netflix.servo.annotations.Monitor object3 = field.getAnnotation(clazz2);
                if (object3 == null) continue;
                object2 = Monitors.newConfig(object.getClass(), string, object3, tagList);
                if (object3.type() == DataSourceType.INFORMATIONAL) {
                    list.add(new AnnotatedStringMonitor((MonitorConfig)object2, object, field));
                    continue;
                }
                Monitors.checkType(object3, field.getType(), clazz);
                list.add(new AnnotatedNumberMonitor((MonitorConfig)object2, object, field));
            }
            for (AccessibleObject accessibleObject : accessibleObjectArray = clazz.getDeclaredMethods()) {
                object2 = ((Method)accessibleObject).getAnnotation(clazz2);
                if (object2 == null) continue;
                MonitorConfig monitorConfig = Monitors.newConfig(object.getClass(), string, (com.netflix.servo.annotations.Monitor)object2, tagList);
                if (object2.type() == DataSourceType.INFORMATIONAL) {
                    list.add(new AnnotatedStringMonitor(monitorConfig, object, accessibleObject));
                    continue;
                }
                Monitors.checkType((com.netflix.servo.annotations.Monitor)object2, ((Method)accessibleObject).getReturnType(), clazz);
                list.add(new AnnotatedNumberMonitor(monitorConfig, object, accessibleObject));
            }
        }
        catch (Exception exception) {
            throw Throwables.propagate((Throwable)exception);
        }
    }

    private static TagList getMonitorTags(Object object) {
        try {
            Class<?> clazz = object.getClass();
            Field[] fieldArray = clazz.getDeclaredFields();
            AccessibleObject[] accessibleObjectArray = fieldArray;
            int n = accessibleObjectArray.length;
            for (int i = 0; i < n; ++i) {
                Field field = accessibleObjectArray[i];
                MonitorTags object2 = field.getAnnotation(MonitorTags.class);
                if (object2 == null) continue;
                field.setAccessible(true);
                return (TagList)field.get(object);
            }
            for (AccessibleObject accessibleObject : accessibleObjectArray = clazz.getDeclaredMethods()) {
                MonitorTags monitorTags = ((Method)accessibleObject).getAnnotation(MonitorTags.class);
                if (monitorTags == null) continue;
                ((Method)accessibleObject).setAccessible(true);
                return (TagList)((Method)accessibleObject).invoke(object, new Object[0]);
            }
        }
        catch (Exception exception) {
            throw Throwables.propagate((Throwable)exception);
        }
        return null;
    }

    private static void checkType(com.netflix.servo.annotations.Monitor monitor, Class<?> clazz, Class<?> clazz2) {
        if (!Monitors.isNumericType(clazz)) {
            String string = "annotation of type " + monitor.type().name() + " can only be used" + " with numeric values, " + monitor.name() + " in class " + clazz2.getName() + " is applied to a field or method of type " + clazz.getName();
            throw new IllegalArgumentException(string);
        }
    }

    private static boolean isNumericType(Class<?> clazz) {
        return Number.class.isAssignableFrom(clazz) || Double.TYPE == clazz || Float.TYPE == clazz || Long.TYPE == clazz || Integer.TYPE == clazz || Short.TYPE == clazz || Byte.TYPE == clazz;
    }

    private static boolean isMonitorType(Class<?> clazz) {
        return Monitor.class.isAssignableFrom(clazz);
    }

    private static MonitorConfig newObjectConfig(Class<?> clazz, String string, TagList tagList) {
        MonitorConfig.Builder builder = MonitorConfig.builder(string);
        builder.withTag("class", clazz.getSimpleName());
        if (tagList != null) {
            builder.withTags(tagList);
        }
        return builder.build();
    }

    private static MonitorConfig newConfig(Class<?> clazz, String string, com.netflix.servo.annotations.Monitor monitor, TagList tagList) {
        MonitorConfig.Builder builder = MonitorConfig.builder(monitor.name());
        builder.withTag("class", clazz.getSimpleName());
        builder.withTag(monitor.type());
        builder.withTag(monitor.level());
        if (tagList != null) {
            builder.withTags(tagList);
        }
        if (string != null) {
            builder.withTag("id", string);
        }
        return builder.build();
    }

    private static class CounterFactory
    implements Function<MonitorConfig, Counter> {
        private CounterFactory() {
        }

        public Counter apply(MonitorConfig monitorConfig) {
            return new BasicCounter(monitorConfig);
        }
    }

    private static class TimerFactory
    implements Function<MonitorConfig, Timer> {
        private final TimeUnit unit;

        public TimerFactory(TimeUnit timeUnit) {
            this.unit = timeUnit;
        }

        public Timer apply(MonitorConfig monitorConfig) {
            return new BasicTimer(monitorConfig, this.unit);
        }
    }
}

