/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.netflix.servo.tag.BasicTag;
import com.netflix.servo.tag.SortedTagList;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class MonitorConfig {
    private final String name;
    private final TagList tags;

    public static Builder builder(String string) {
        return new Builder(string);
    }

    private MonitorConfig(Builder builder) {
        this.name = (String)Preconditions.checkNotNull((Object)builder.name, (Object)"name cannot be null");
        this.tags = builder.tags.isEmpty() ? SortedTagList.EMPTY : SortedTagList.builder().withTags(builder.tags).build();
    }

    public String getName() {
        return this.name;
    }

    public TagList getTags() {
        return this.tags;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof MonitorConfig)) {
            return false;
        }
        MonitorConfig monitorConfig = (MonitorConfig)object;
        return this.name.equals(monitorConfig.getName()) && this.tags.equals(monitorConfig.getTags());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.tags});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("tags", (Object)this.tags).toString();
    }

    public MonitorConfig withAdditionalTag(Tag tag) {
        return MonitorConfig.builder(this.name).withTags(this.tags).withTag(tag).build();
    }

    public MonitorConfig withAdditionalTags(TagList tagList) {
        return MonitorConfig.builder(this.name).withTags(this.tags).withTags(tagList).build();
    }

    public static class Builder {
        private final String name;
        private final List<Tag> tags = new LinkedList<Tag>();

        public Builder(String string) {
            this.name = string;
        }

        public Builder withTag(String string, String string2) {
            this.tags.add(new BasicTag(string, string2));
            return this;
        }

        public Builder withTag(Tag tag) {
            this.tags.add(new BasicTag(tag.getKey(), tag.getValue()));
            return this;
        }

        public Builder withTags(TagList tagList) {
            if (tagList != null) {
                for (Tag tag : tagList) {
                    this.tags.add(tag);
                }
            }
            return this;
        }

        public Builder withTags(Collection<Tag> collection) {
            this.tags.addAll(collection);
            return this;
        }

        public MonitorConfig build() {
            return new MonitorConfig(this);
        }
    }
}

