/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Gauge;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.ResettableMonitor;
import java.util.concurrent.atomic.AtomicLong;

public class MinGauge
extends AbstractMonitor<Long>
implements Gauge<Long>,
ResettableMonitor<Long> {
    private AtomicLong min = new AtomicLong(Long.MAX_VALUE);

    public MinGauge(MonitorConfig monitorConfig) {
        super(monitorConfig.withAdditionalTag(DataSourceType.GAUGE));
    }

    public void update(long l) {
        if (l < this.min.get()) {
            this.min.set(l);
        }
    }

    @Override
    public Long getValue() {
        long l = this.min.get();
        return l == Long.MAX_VALUE ? 0L : l;
    }

    @Override
    public Long getAndResetValue() {
        long l = this.min.getAndSet(Long.MAX_VALUE);
        return l == Long.MAX_VALUE ? 0L : l;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof MinGauge)) {
            return false;
        }
        MinGauge minGauge = (MinGauge)object;
        return this.config.equals(minGauge.getConfig()) && this.min.get() == minGauge.min.get();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.min.get()});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("min", this.min.get()).toString();
    }
}

