/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.MonitorConfig;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class AnnotatedStringMonitor
extends AbstractMonitor<String> {
    private final Object object;
    private final AccessibleObject field;

    AnnotatedStringMonitor(MonitorConfig monitorConfig, Object object, AccessibleObject accessibleObject) {
        super(monitorConfig);
        this.object = object;
        this.field = accessibleObject;
    }

    @Override
    public String getValue() {
        Object object = null;
        try {
            this.field.setAccessible(true);
            object = this.field instanceof Field ? ((Field)this.field).get(this.object) : ((Method)this.field).invoke(this.object, new Object[0]);
        }
        catch (Exception exception) {
            throw Throwables.propagate((Throwable)exception);
        }
        return object == null ? null : object.toString();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AnnotatedStringMonitor)) {
            return false;
        }
        AnnotatedStringMonitor annotatedStringMonitor = (AnnotatedStringMonitor)object;
        return this.config.equals(annotatedStringMonitor.getConfig()) && this.field.equals(annotatedStringMonitor.field);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.field});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("field", (Object)this.field).toString();
    }
}

