/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.tag.TaggingContext;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractContextualMonitor<T, M extends Monitor<T>>
implements CompositeMonitor<T> {
    protected final MonitorConfig baseConfig;
    protected final TaggingContext context;
    protected final Function<MonitorConfig, M> newMonitor;
    protected final ConcurrentMap<MonitorConfig, M> monitors;

    protected AbstractContextualMonitor(MonitorConfig monitorConfig, TaggingContext taggingContext, Function<MonitorConfig, M> function) {
        this.baseConfig = monitorConfig;
        this.context = taggingContext;
        this.newMonitor = function;
        this.monitors = new ConcurrentHashMap<MonitorConfig, M>();
    }

    protected M getMonitorForCurrentContext() {
        Monitor monitor;
        MonitorConfig monitorConfig = this.getConfig();
        Monitor monitor2 = (Monitor)this.monitors.get(monitorConfig);
        if (monitor2 == null && (monitor2 = this.monitors.putIfAbsent(monitorConfig, monitor = (Monitor)this.newMonitor.apply((Object)monitorConfig))) == null) {
            monitor2 = monitor;
        }
        return (M)monitor2;
    }

    @Override
    public MonitorConfig getConfig() {
        TagList tagList = this.context.getTags();
        return MonitorConfig.builder(this.baseConfig.getName()).withTags(this.baseConfig.getTags()).withTags(tagList).build();
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        return ImmutableList.copyOf(this.monitors.values());
    }
}

