/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.jmx;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.NumericMonitor;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;

class MonitorMBean
implements DynamicMBean {
    private final Monitor<?> monitor;
    private final ObjectName objectName;
    private final MBeanInfo beanInfo;

    public static List<MonitorMBean> createMBeans(String string, Monitor<?> monitor) {
        ArrayList arrayList = Lists.newArrayList();
        MonitorMBean.createMBeans(arrayList, string, monitor);
        return arrayList;
    }

    private static void createMBeans(List<MonitorMBean> list, String string, Monitor<?> monitor) {
        if (monitor instanceof CompositeMonitor) {
            for (Monitor<?> monitor2 : ((CompositeMonitor)monitor).getMonitors()) {
                MonitorMBean.createMBeans(list, string, monitor2);
            }
        } else {
            list.add(new MonitorMBean(string, monitor));
        }
    }

    MonitorMBean(String string, Monitor<?> monitor) {
        this.monitor = monitor;
        this.objectName = this.createObjectName(string);
        this.beanInfo = this.createBeanInfo();
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public Object getAttribute(String string) throws AttributeNotFoundException {
        return this.monitor.getValue();
    }

    @Override
    public void setAttribute(Attribute attribute) throws InvalidAttributeValueException, MBeanException, AttributeNotFoundException {
        throw new UnsupportedOperationException("setAttribute is not implemented");
    }

    @Override
    public AttributeList getAttributes(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        for (String string : stringArray) {
            attributeList.add(new Attribute(string, this.monitor.getValue()));
        }
        return attributeList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributeList) {
        throw new UnsupportedOperationException("setAttributes is not implemented");
    }

    @Override
    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        throw new UnsupportedOperationException("invoke is not implemented");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.beanInfo;
    }

    private ObjectName createObjectName(String string) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string).append(':');
            stringBuilder.append("name=").append(this.monitor.getConfig().getName());
            TagList tagList = this.monitor.getConfig().getTags();
            for (Tag tag : tagList) {
                stringBuilder.append(',').append(tag.getKey()).append('=').append(tag.getValue());
            }
            return new ObjectName(stringBuilder.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw Throwables.propagate((Throwable)exception);
        }
    }

    private MBeanInfo createBeanInfo() {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[]{this.createAttributeInfo(this.monitor)};
        return new MBeanInfo(this.getClass().getName(), "MonitorMBean", mBeanAttributeInfoArray, null, null, null);
    }

    private MBeanAttributeInfo createAttributeInfo(Monitor<?> monitor) {
        String string = monitor instanceof NumericMonitor ? Number.class.getName() : String.class.getName();
        return new MBeanAttributeInfo("value", string, monitor.getConfig().toString(), true, false, false);
    }
}

