/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.jmx;

import com.google.common.collect.ImmutableSet;
import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.jmx.MonitorMBean;
import com.netflix.servo.monitor.Monitor;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.DynamicMBean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmxMonitorRegistry
implements MonitorRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(JmxMonitorRegistry.class);
    private final MBeanServer mBeanServer;
    private final Set<Monitor<?>> monitors;
    private final String name;

    public JmxMonitorRegistry(String string) {
        this.name = string;
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.monitors = Collections.synchronizedSet(new HashSet());
    }

    private void register(ObjectName objectName, DynamicMBean dynamicMBean) throws Exception {
        if (this.mBeanServer.isRegistered(objectName)) {
            this.mBeanServer.unregisterMBean(objectName);
        }
        this.mBeanServer.registerMBean(dynamicMBean, objectName);
    }

    @Override
    public Set<Monitor<?>> getRegisteredMonitors() {
        return ImmutableSet.copyOf(this.monitors);
    }

    @Override
    public void register(Monitor<?> monitor) {
        try {
            List<MonitorMBean> list = MonitorMBean.createMBeans(this.name, monitor);
            for (MonitorMBean monitorMBean : list) {
                this.register(monitorMBean.getObjectName(), monitorMBean);
            }
            this.monitors.add(monitor);
        }
        catch (Exception exception) {
            LOG.warn("Unable to register Monitor:" + monitor.getConfig(), (Throwable)exception);
        }
    }

    @Override
    public void unregister(Monitor<?> monitor) {
        try {
            List<MonitorMBean> list = MonitorMBean.createMBeans(this.name, monitor);
            for (MonitorMBean monitorMBean : list) {
                this.mBeanServer.unregisterMBean(monitorMBean.getObjectName());
            }
            this.monitors.remove(monitor);
        }
        catch (Exception exception) {
            LOG.warn("Unable to un-register Monitor:" + monitor.getConfig(), (Throwable)exception);
        }
    }
}

