/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.examples;

import java.net.MalformedURLException;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public final class JmxClientExample {
    private static final int INDENT_SPACES = 4;

    private JmxClientExample() {
    }

    private static JMXServiceURL mkJmxUrl(String string, String string2) throws MalformedURLException {
        String string3 = String.format("service:jmx:rmi://%1$s:%2$s/jndi/rmi://%1$s:%2$s/jmxrmi", string, string2);
        return new JMXServiceURL(string3);
    }

    private static void println(int n, String string) {
        for (int i = 0; i < n * 4; ++i) {
            System.out.print(" ");
        }
        System.out.println(string);
    }

    private static void dumpValue(int n, String string, Object object) {
        if (object instanceof CompositeData) {
            CompositeData compositeData = (CompositeData)object;
            JmxClientExample.println(n, String.format("%s:", string));
            for (String string2 : compositeData.getCompositeType().keySet()) {
                JmxClientExample.dumpValue(n + 1, string2, compositeData.get(string2));
            }
        } else {
            JmxClientExample.println(n, String.format("%s => %s", string, object));
        }
    }

    private static void dumpObj(MBeanServerConnection mBeanServerConnection, ObjectName objectName) throws Exception {
        System.out.println("ObjectName: " + objectName.toString());
        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanServerConnection.getMBeanInfo(objectName).getAttributes();
        if (mBeanAttributeInfoArray != null) {
            String[] stringArray = new String[mBeanAttributeInfoArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = mBeanAttributeInfoArray[i].getName();
            }
            AttributeList attributeList = mBeanServerConnection.getAttributes(objectName, stringArray);
            for (Attribute attribute : attributeList.asList()) {
                JmxClientExample.dumpValue(1, attribute.getName(), attribute.getValue());
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("Usage: JMXClientExample <host> <port>");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        JMXServiceURL jMXServiceURL = JmxClientExample.mkJmxUrl(string, string2);
        MBeanServerConnection mBeanServerConnection = JMXConnectorFactory.connect(jMXServiceURL, null).getMBeanServerConnection();
        ObjectName objectName = new ObjectName("com.netflix.servo.jmx.MonitoredResource:*");
        Set<ObjectName> set = mBeanServerConnection.queryNames(objectName, null);
        for (ObjectName objectName2 : set) {
            JmxClientExample.dumpObj(mBeanServerConnection, objectName2);
        }
    }
}

