/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.examples;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.CountingInputStream;
import com.google.common.io.CountingOutputStream;
import com.netflix.servo.publish.BasicMetricFilter;
import com.netflix.servo.publish.CounterToRateMetricTransform;
import com.netflix.servo.publish.FileMetricObserver;
import com.netflix.servo.publish.MetricPoller;
import com.netflix.servo.publish.MonitorRegistryMetricPoller;
import com.netflix.servo.publish.PollRunnable;
import com.netflix.servo.publish.PollScheduler;
import com.netflix.servo.tag.BasicTag;
import com.netflix.servo.tag.SortedTagList;
import com.netflix.servo.tag.TagList;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoServerExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(EchoServerExample.class);
    private final int port;

    public EchoServerExample(int n) {
        this.port = n;
    }

    public void start() throws IOException {
        AcceptTask acceptTask = new AcceptTask(this.port);
        Thread thread = new Thread((Runnable)acceptTask, "AcceptTask");
        thread.start();
    }

    public void shutdown() {
    }

    public static void main(String[] stringArray) throws Exception {
        PollScheduler pollScheduler = PollScheduler.getInstance();
        pollScheduler.start();
        CounterToRateMetricTransform counterToRateMetricTransform = new CounterToRateMetricTransform(new FileMetricObserver("serverstat", new File(".")), 20L, TimeUnit.SECONDS);
        PollRunnable pollRunnable = new PollRunnable((MetricPoller)new MonitorRegistryMetricPoller(), BasicMetricFilter.MATCH_ALL, counterToRateMetricTransform);
        pollScheduler.addPoller(pollRunnable, 10L, TimeUnit.SECONDS);
        int n = 54321;
        if (stringArray.length > 0) {
            n = Integer.valueOf(stringArray[0]);
        }
        EchoServerExample echoServerExample = new EchoServerExample(n);
        echoServerExample.start();
    }

    public static class ClientTask
    implements Runnable {
        private final TagList tags;
        private final Socket s;

        public ClientTask(TagList tagList, Socket socket) {
            this.tags = tagList;
            this.s = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doWork() throws IOException {
            CountingInputStream countingInputStream = null;
            CountingOutputStream countingOutputStream = null;
            try {
                countingInputStream = new CountingInputStream(this.s.getInputStream());
                countingOutputStream = new CountingOutputStream(this.s.getOutputStream());
                ByteStreams.copy((InputStream)countingInputStream, (OutputStream)countingOutputStream);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(countingInputStream);
                Closeables.closeQuietly(countingOutputStream);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)countingInputStream);
            Closeables.closeQuietly((Closeable)countingOutputStream);
        }

        @Override
        public void run() {
            try {
                this.doWork();
            }
            catch (IOException iOException) {
                SocketAddress socketAddress = this.s.getRemoteSocketAddress();
                LOGGER.error("failure handling connection from " + socketAddress, (Throwable)iOException);
            }
        }
    }

    public static class AcceptTask
    implements Runnable {
        private static final String[] COUNTRIES = new String[]{"US", "CA", "GB", "IE"};
        private final ServerSocket ss;
        private final Random r = new Random();

        public AcceptTask(int n) throws IOException {
            this.ss = new ServerSocket(n);
        }

        public TagList getTags(Socket socket) {
            String string = COUNTRIES[this.r.nextInt(COUNTRIES.length)];
            return SortedTagList.builder().withTag(new BasicTag("Country", string)).build();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Socket socket = this.ss.accept();
                        TagList tagList = this.getTags(socket);
                        LOGGER.info("received connection from {} with tags {}", (Object)socket.getRemoteSocketAddress(), (Object)tagList);
                        ClientTask clientTask = new ClientTask(tagList, socket);
                        Thread thread = new Thread((Runnable)clientTask, "ClientTask");
                        thread.start();
                    }
                }
                catch (IOException iOException) {
                    LOGGER.error("failure accepting connection", (Throwable)iOException);
                    continue;
                }
                break;
            }
        }
    }
}

