/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.TagList;

public final class Metric {
    private final MonitorConfig config;
    private final long timestamp;
    private final Object value;

    public Metric(String string, TagList tagList, long l, Object object) {
        this(new MonitorConfig.Builder(string).withTags(tagList).build(), l, object);
    }

    public Metric(MonitorConfig monitorConfig, long l, Object object) {
        this.config = (MonitorConfig)Preconditions.checkNotNull((Object)monitorConfig, (Object)"config cannot be null");
        this.timestamp = l;
        this.value = Preconditions.checkNotNull((Object)object, (String)"value cannot be null (config=%s)", (Object[])new Object[]{monitorConfig});
    }

    public MonitorConfig getConfig() {
        return this.config;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Object getValue() {
        return this.value;
    }

    public Number getNumberValue() {
        return (Number)this.value;
    }

    public boolean hasNumberValue() {
        return this.value instanceof Number;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Metric)) {
            return false;
        }
        Metric metric = (Metric)object;
        return this.config.equals(metric.getConfig()) && this.timestamp == metric.getTimestamp() && this.value.equals(metric.getValue());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.timestamp, this.value});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("timestamp", this.timestamp).add("value", this.value).toString();
    }
}

