/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo;

import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.jmx.JmxMonitorRegistry;
import com.netflix.servo.monitor.Monitor;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultMonitorRegistry
implements MonitorRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMonitorRegistry.class);
    private static final String CLASS_NAME = DefaultMonitorRegistry.class.getCanonicalName();
    private static final String REGISTRY_CLASS_PROP = CLASS_NAME + ".registryClass";
    private static final MonitorRegistry INSTANCE = new DefaultMonitorRegistry();
    private static final String DEFAULT_REGISTRY_NAME = "com.netflix.servo";
    private final MonitorRegistry registry;

    public static MonitorRegistry getInstance() {
        return INSTANCE;
    }

    DefaultMonitorRegistry() {
        this(System.getProperties());
    }

    DefaultMonitorRegistry(Properties properties) {
        String string = properties.getProperty(REGISTRY_CLASS_PROP);
        if (string != null) {
            MonitorRegistry monitorRegistry = null;
            try {
                Class<?> clazz = Class.forName(string);
                monitorRegistry = (MonitorRegistry)clazz.newInstance();
            }
            catch (Throwable throwable) {
                LOG.error("failed to create instance of class " + string + ", " + "using default class " + JmxMonitorRegistry.class.getName(), throwable);
                monitorRegistry = new JmxMonitorRegistry(DEFAULT_REGISTRY_NAME);
            }
            this.registry = monitorRegistry;
        } else {
            this.registry = new JmxMonitorRegistry(DEFAULT_REGISTRY_NAME);
        }
    }

    @Override
    public Set<Monitor<?>> getRegisteredMonitors() {
        return this.registry.getRegisteredMonitors();
    }

    @Override
    public void register(Monitor<?> monitor) {
        this.registry.register(monitor);
    }

    @Override
    public void unregister(Monitor<?> monitor) {
        this.registry.unregister(monitor);
    }

    MonitorRegistry getInnerRegistry() {
        return this.registry;
    }
}

