/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.netflix.servo.SpectatorContext;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.NumericMonitor;
import com.netflix.servo.monitor.SpectatorMonitor;
import com.netflix.servo.util.Throwables;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class AnnotatedNumberMonitor
extends AbstractMonitor<Number>
implements NumericMonitor<Number>,
SpectatorMonitor {
    private final Object object;
    private final AccessibleObject field;

    AnnotatedNumberMonitor(MonitorConfig config, Object object, AccessibleObject field) {
        super(config);
        this.object = object;
        this.field = field;
        if ("COUNTER".equals(config.getTags().getValue("type"))) {
            SpectatorContext.polledGauge(config).monitorMonotonicCounter((Object)this, m -> m.getValue(0).longValue());
        } else {
            SpectatorContext.polledGauge(config).monitorValue((Object)this, m -> m.getValue(0).doubleValue());
        }
    }

    @Override
    public Number getValue(int pollerIdx) {
        try {
            this.field.setAccessible(true);
            if (this.field instanceof Field) {
                return (Number)((Field)this.field).get(this.object);
            }
            return (Number)((Method)this.field).invoke(this.object, new Object[0]);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AnnotatedNumberMonitor)) {
            return false;
        }
        AnnotatedNumberMonitor m = (AnnotatedNumberMonitor)obj;
        return this.config.equals(m.getConfig()) && this.field.equals(m.field);
    }

    public int hashCode() {
        int result = this.config.hashCode();
        result = 31 * result + this.field.hashCode();
        return result;
    }

    public String toString() {
        return "AnnotatedNumberMonitor{config=" + this.config + ", field=" + this.field + '}';
    }
}

