/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.DoubleGauge;
import com.netflix.servo.monitor.LongGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.NumericMonitor;
import com.netflix.servo.stats.StatsBuffer;
import com.netflix.servo.stats.StatsConfig;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.Tags;
import com.netflix.servo.util.Clock;
import com.netflix.servo.util.ThreadFactories;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsMonitor
extends AbstractMonitor<Long>
implements CompositeMonitor<Long>,
NumericMonitor<Long> {
    protected static final ScheduledExecutorService DEFAULT_EXECUTOR;
    private static final long EXPIRE_AFTER_MS;
    private static final Logger LOGGER;
    private final MonitorConfig baseConfig;
    protected final Counter count;
    protected final Counter totalMeasurement;
    private final List<Monitor<?>> monitors;
    private final List<GaugeWrapper> gaugeWrappers;
    private final Runnable startComputingAction;
    private final Object updateLock = new Object();
    private StatsBuffer cur;
    private StatsBuffer prev;
    private static final String STATISTIC = "statistic";
    private static final String PERCENTILE_FMT = "percentile_%.2f";
    private static final Tag STAT_COUNT;
    private static final Tag STAT_MIN;
    private static final Tag STAT_MAX;
    private static final Tag STAT_MEAN;
    private static final Tag STAT_VARIANCE;
    private static final Tag STAT_STDDEV;
    private final Clock clock;
    private volatile long lastUsed;
    private final ScheduledExecutorService executor;
    private final StatsConfig statsConfig;
    private AtomicReference<ScheduledFuture<?>> myFutureRef = new AtomicReference();

    private List<Counter> getCounters(StatsConfig config) {
        ArrayList<Counter> counters = new ArrayList<Counter>();
        if (config.getPublishCount()) {
            counters.add(this.count);
        }
        if (config.getPublishTotal()) {
            counters.add(this.totalMeasurement);
        }
        return counters;
    }

    private List<GaugeWrapper> getGaugeWrappers(StatsConfig config) {
        ArrayList<GaugeWrapper> wrappers = new ArrayList<GaugeWrapper>();
        if (config.getPublishMax()) {
            wrappers.add(new MaxGaugeWrapper(this.baseConfig));
        }
        if (config.getPublishMin()) {
            wrappers.add(new MinStatGaugeWrapper(this.baseConfig));
        }
        if (config.getPublishVariance()) {
            wrappers.add(new VarianceGaugeWrapper(this.baseConfig));
        }
        if (config.getPublishStdDev()) {
            wrappers.add(new StdDevGaugeWrapper(this.baseConfig));
        }
        if (config.getPublishMean()) {
            wrappers.add(new MeanGaugeWrapper(this.baseConfig));
        }
        double[] percentiles = config.getPercentiles();
        for (int i = 0; i < percentiles.length; ++i) {
            wrappers.add(new PercentileGaugeWrapper(this.baseConfig, percentiles[i], i));
        }
        HashSet<MonitorConfig> seen = new HashSet<MonitorConfig>();
        for (GaugeWrapper wrapper : wrappers) {
            MonitorConfig cfg = wrapper.getMonitor().getConfig();
            if (seen.contains(cfg)) {
                throw new IllegalArgumentException("Duplicated monitor configuration found: " + cfg);
            }
            seen.add(cfg);
        }
        return wrappers;
    }

    public StatsMonitor(MonitorConfig config, StatsConfig statsConfig, ScheduledExecutorService executor, String totalTagName, boolean autoStart, Tag ... additionalTags) {
        this(config, statsConfig, executor, totalTagName, autoStart, Clock.WALL, additionalTags);
    }

    public StatsMonitor(MonitorConfig config, StatsConfig statsConfig, ScheduledExecutorService executor, String totalTagName, boolean autoStart, Clock clock, Tag ... additionalTags) {
        super(config);
        Tag statsTotal = Tags.newTag(STATISTIC, totalTagName);
        this.baseConfig = config.withAdditionalTags(new BasicTagList(Arrays.asList(additionalTags)));
        this.clock = clock;
        this.lastUsed = clock.now();
        this.executor = executor;
        this.statsConfig = statsConfig;
        this.cur = new StatsBuffer(statsConfig.getSampleSize(), statsConfig.getPercentiles());
        this.prev = new StatsBuffer(statsConfig.getSampleSize(), statsConfig.getPercentiles());
        this.count = new BasicCounter(this.baseConfig.withAdditionalTag(STAT_COUNT));
        this.totalMeasurement = new BasicCounter(this.baseConfig.withAdditionalTag(statsTotal));
        this.gaugeWrappers = this.getGaugeWrappers(statsConfig);
        List gaugeMonitors = this.gaugeWrappers.stream().map(GaugeWrapper::getMonitor).collect(Collectors.toList());
        ArrayList<Counter> monitorList = new ArrayList<Counter>();
        monitorList.addAll(this.getCounters(statsConfig));
        monitorList.addAll(gaugeMonitors);
        this.monitors = Collections.unmodifiableList(monitorList);
        this.startComputingAction = () -> this.startComputingStats(executor, statsConfig.getFrequencyMillis());
        if (autoStart) {
            this.startComputingStats();
        }
    }

    public void startComputingStats() {
        this.startComputingAction.run();
    }

    private void startComputingStats(ScheduledExecutorService executor, long frequencyMillis) {
        Runnable command = () -> {
            try {
                boolean expired;
                if (this.myFutureRef.get() == null) {
                    return;
                }
                boolean bl = expired = this.clock.now() - this.lastUsed > EXPIRE_AFTER_MS;
                if (expired) {
                    ScheduledFuture future = this.myFutureRef.getAndSet(null);
                    if (future != null) {
                        LOGGER.debug("Expiring unused StatsMonitor {}", (Object)this.getConfig().getName());
                        future.cancel(true);
                    }
                    return;
                }
                Object object = this.updateLock;
                synchronized (object) {
                    StatsBuffer tmp = this.prev;
                    this.prev = this.cur;
                    this.cur = tmp;
                }
                this.prev.computeStats();
                this.updateGauges();
                this.prev.reset();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        };
        this.myFutureRef.set(executor.scheduleWithFixedDelay(command, frequencyMillis, frequencyMillis, TimeUnit.MILLISECONDS));
    }

    private void updateGauges() {
        for (GaugeWrapper gauge : this.gaugeWrappers) {
            gauge.update(this.prev);
        }
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        this.lastUsed = this.clock.now();
        if (this.isExpired()) {
            LOGGER.info("Attempting to get the value for an expired monitor: {}.Will start computing stats again.", (Object)this.getConfig().getName());
            this.startComputingStats(this.executor, this.statsConfig.getFrequencyMillis());
            return Collections.emptyList();
        }
        return this.monitors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(long measurement) {
        Object object = this.updateLock;
        synchronized (object) {
            this.cur.record(measurement);
        }
        this.count.increment();
        this.totalMeasurement.increment(measurement);
    }

    @Override
    public Long getValue(int pollerIndex) {
        long n = this.getCount(pollerIndex);
        return n > 0L ? ((Number)this.totalMeasurement.getValue(pollerIndex)).longValue() / n : 0L;
    }

    @Override
    public Long getValue() {
        return this.getValue(0);
    }

    protected void handleException(Exception e) {
        LOGGER.warn("Unable to compute stats: ", (Throwable)e);
    }

    public String toString() {
        return "StatsMonitor{baseConfig=" + this.baseConfig + ", monitors=" + this.monitors + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof StatsMonitor)) {
            return false;
        }
        StatsMonitor m = (StatsMonitor)obj;
        return this.baseConfig.equals(m.baseConfig) && this.monitors.equals(m.monitors);
    }

    public int hashCode() {
        int result = this.baseConfig.hashCode();
        result = 31 * result + this.monitors.hashCode();
        return result;
    }

    public long getCount(int pollerIndex) {
        return ((Number)this.count.getValue(pollerIndex)).longValue();
    }

    public long getTotalMeasurement() {
        return ((Number)this.totalMeasurement.getValue()).longValue();
    }

    boolean isExpired() {
        return this.myFutureRef.get() == null;
    }

    static {
        String className = StatsMonitor.class.getCanonicalName();
        String expirationProp = className + ".expiration";
        String expirationPropUnit = className + ".expirationUnit";
        String expiration = System.getProperty(expirationProp, "15");
        String expirationUnit = System.getProperty(expirationPropUnit, "MINUTES");
        long expirationValue = Long.parseLong(expiration);
        TimeUnit expirationUnitValue = TimeUnit.valueOf(expirationUnit);
        EXPIRE_AFTER_MS = expirationUnitValue.toMillis(expirationValue);
        ThreadFactory threadFactory = ThreadFactories.withName("StatsMonitor-%d");
        ScheduledThreadPoolExecutor poolExecutor = new ScheduledThreadPoolExecutor(1, threadFactory);
        poolExecutor.setRemoveOnCancelPolicy(true);
        DEFAULT_EXECUTOR = poolExecutor;
        LOGGER = LoggerFactory.getLogger(StatsMonitor.class);
        STAT_COUNT = Tags.newTag(STATISTIC, "count");
        STAT_MIN = Tags.newTag(STATISTIC, "min");
        STAT_MAX = Tags.newTag(STATISTIC, "max");
        STAT_MEAN = Tags.newTag(STATISTIC, "avg");
        STAT_VARIANCE = Tags.newTag(STATISTIC, "variance");
        STAT_STDDEV = Tags.newTag(STATISTIC, "stdDev");
    }

    private static class PercentileGaugeWrapper
    extends DoubleGaugeWrapper {
        private final double percentile;
        private final int index;

        private static Tag percentileTag(double percentile) {
            String percentileStr = String.format(StatsMonitor.PERCENTILE_FMT, percentile);
            if (percentileStr.endsWith(".00")) {
                percentileStr = percentileStr.substring(0, percentileStr.length() - 3);
            }
            return Tags.newTag(StatsMonitor.STATISTIC, percentileStr);
        }

        PercentileGaugeWrapper(MonitorConfig baseConfig, double percentile, int index) {
            super(baseConfig.withAdditionalTag(PercentileGaugeWrapper.percentileTag(percentile)));
            this.percentile = percentile;
            this.index = index;
        }

        @Override
        public void update(StatsBuffer buffer) {
            this.gauge.set(buffer.getPercentileValues()[this.index]);
        }

        @Override
        public String toString() {
            return "PercentileGaugeWrapper{gauge=" + this.gauge + "percentile=" + this.percentile + '}';
        }
    }

    private static class StdDevGaugeWrapper
    extends DoubleGaugeWrapper {
        StdDevGaugeWrapper(MonitorConfig baseConfig) {
            super(baseConfig.withAdditionalTag(STAT_STDDEV));
        }

        @Override
        public void update(StatsBuffer buffer) {
            this.gauge.set(buffer.getStdDev());
        }
    }

    private static class VarianceGaugeWrapper
    extends DoubleGaugeWrapper {
        VarianceGaugeWrapper(MonitorConfig baseConfig) {
            super(baseConfig.withAdditionalTag(STAT_VARIANCE));
        }

        @Override
        public void update(StatsBuffer buffer) {
            this.gauge.set(buffer.getVariance());
        }
    }

    private static class MeanGaugeWrapper
    extends DoubleGaugeWrapper {
        MeanGaugeWrapper(MonitorConfig baseConfig) {
            super(baseConfig.withAdditionalTag(STAT_MEAN));
        }

        @Override
        public void update(StatsBuffer buffer) {
            this.gauge.set(buffer.getMean());
        }
    }

    private static class MaxGaugeWrapper
    extends LongGaugeWrapper {
        MaxGaugeWrapper(MonitorConfig baseConfig) {
            super(baseConfig.withAdditionalTag(STAT_MAX));
        }

        @Override
        public void update(StatsBuffer buffer) {
            this.gauge.set(buffer.getMax());
        }
    }

    private static class MinStatGaugeWrapper
    extends LongGaugeWrapper {
        MinStatGaugeWrapper(MonitorConfig baseConfig) {
            super(baseConfig.withAdditionalTag(STAT_MIN));
        }

        @Override
        public void update(StatsBuffer buffer) {
            this.gauge.set(buffer.getMin());
        }
    }

    private static abstract class DoubleGaugeWrapper
    implements GaugeWrapper {
        protected final DoubleGauge gauge;

        protected DoubleGaugeWrapper(MonitorConfig config) {
            this.gauge = new DoubleGauge(config);
        }

        @Override
        public Monitor<?> getMonitor() {
            return this.gauge;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DoubleGaugeWrapper)) {
                return false;
            }
            DoubleGaugeWrapper that = (DoubleGaugeWrapper)o;
            return this.gauge.equals(that.gauge);
        }

        public int hashCode() {
            return this.gauge.hashCode();
        }

        public String toString() {
            return "DoubleGaugeWrapper{gauge=" + this.gauge + '}';
        }
    }

    private static abstract class LongGaugeWrapper
    implements GaugeWrapper {
        protected final LongGauge gauge;

        protected LongGaugeWrapper(MonitorConfig config) {
            this.gauge = new LongGauge(config);
        }

        @Override
        public Monitor<?> getMonitor() {
            return this.gauge;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LongGaugeWrapper)) {
                return false;
            }
            LongGaugeWrapper that = (LongGaugeWrapper)o;
            return this.gauge.equals(that.gauge);
        }

        public int hashCode() {
            return this.gauge.hashCode();
        }

        public String toString() {
            return "LongGaugeWrapper{gauge=" + this.gauge + '}';
        }
    }

    private static interface GaugeWrapper {
        public void update(StatsBuffer var1);

        public Monitor<?> getMonitor();
    }
}

