/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.servo.publish.PollRunnable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class PollScheduler {
    private static final PollScheduler INSTANCE = new PollScheduler();
    private ScheduledExecutorService executor = null;
    private boolean started = false;

    public static PollScheduler getInstance() {
        return INSTANCE;
    }

    private PollScheduler() {
    }

    public void addPoller(PollRunnable task, long delay, TimeUnit timeUnit) {
        if (!this.started) {
            throw new IllegalStateException("you must start the scheduler before tasks can be submitted");
        }
        this.executor.scheduleAtFixedRate(task, 0L, delay, timeUnit);
    }

    public void start() {
        int numThreads = Runtime.getRuntime().availableProcessors();
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ServoPollScheduler-%d").build();
        this.start(Executors.newScheduledThreadPool(numThreads, factory));
    }

    public synchronized void start(ScheduledExecutorService service) {
        if (this.started) {
            throw new IllegalStateException("cannot start scheduler again without stopping it");
        }
        this.executor = service;
        this.started = true;
    }

    public synchronized void stop() {
        if (!this.started) {
            throw new IllegalStateException("scheduler must be started before you stop it");
        }
        this.executor.shutdown();
        this.started = false;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }
}

