/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.Metric;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.publish.MetricObserver;
import com.netflix.servo.publish.MetricPoller;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollRunnable.class);
    private final MetricPoller poller;
    private final MetricFilter filter;
    private final List<MetricObserver> observers;

    public PollRunnable(MetricPoller poller, MetricFilter filter, Collection<MetricObserver> observers) {
        this.poller = (MetricPoller)Preconditions.checkNotNull((Object)poller);
        this.filter = (MetricFilter)Preconditions.checkNotNull((Object)filter);
        this.observers = ImmutableList.copyOf(observers);
    }

    public PollRunnable(MetricPoller poller, MetricFilter filter, MetricObserver ... observers) {
        this(poller, filter, (Collection<MetricObserver>)ImmutableList.copyOf((Object[])observers));
    }

    @Override
    public void run() {
        try {
            List<Metric> metrics = this.poller.poll(this.filter);
            for (MetricObserver o : this.observers) {
                try {
                    o.update(metrics);
                }
                catch (Throwable t) {
                    LOGGER.warn("failed to send metrics to " + o.getName(), t);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.warn("failed to poll metrics", t);
        }
    }
}

