/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.collect.Lists;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.Metric;
import com.netflix.servo.MetricConfig;
import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.annotations.AnnotatedAttribute;
import com.netflix.servo.annotations.AnnotatedObject;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.publish.MetricPoller;
import com.netflix.servo.tag.BasicTagList;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MonitorRegistryMetricPoller
implements MetricPoller {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorRegistryMetricPoller.class);
    private final MonitorRegistry registry;

    public MonitorRegistryMetricPoller() {
        this(DefaultMonitorRegistry.getInstance());
    }

    public MonitorRegistryMetricPoller(MonitorRegistry registry) {
        this.registry = registry;
    }

    private void getMetrics(List<Metric> metrics, MetricFilter filter, AnnotatedObject obj) throws Exception {
        String classId = obj.getId();
        LOGGER.debug("retrieving metrics from class {} id {}", (Object)obj.getClassName(), (Object)classId);
        List<AnnotatedAttribute> attrs = obj.getAttributes();
        for (AnnotatedAttribute attr : attrs) {
            MetricConfig config;
            Monitor anno = attr.getAnnotation();
            BasicTagList tags = BasicTagList.concat(attr.getTags(), anno.type());
            if (anno.type() == DataSourceType.INFORMATIONAL || !filter.matches(config = new MetricConfig(anno.name(), tags))) continue;
            Number num = attr.getNumber();
            if (num != null) {
                long now = System.currentTimeMillis();
                metrics.add(new Metric(config, now, num));
                continue;
            }
            LOGGER.debug("expected number but found {}, metric {}", attr.getValue(), (Object)config);
        }
    }

    @Override
    public List<Metric> poll(MetricFilter filter) {
        ArrayList metrics = Lists.newArrayList();
        for (AnnotatedObject obj : this.registry.getRegisteredObjects()) {
            try {
                this.getMetrics(metrics, filter, obj);
            }
            catch (Exception e) {
                LOGGER.warn("failed to extract metrics from class {}", (Object)e, (Object)obj.getClass().getCanonicalName());
            }
        }
        return metrics;
    }
}

