/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.netflix.servo.Metric;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.annotations.MonitorId;
import com.netflix.servo.publish.MetricObserver;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BaseMetricObserver
implements MetricObserver {
    @MonitorId
    private final String name;
    @Monitor(name="UpdateCount", type=DataSourceType.COUNTER, description="Total number of times update has been called.")
    private final AtomicInteger updateCount = new AtomicInteger(0);
    @Monitor(name="UpdateFailureCount", type=DataSourceType.COUNTER, description="Number of times update failed with an exception.")
    private final AtomicInteger failedUpdateCount = new AtomicInteger(0);

    public BaseMetricObserver(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    public abstract void updateImpl(List<Metric> var1);

    @Override
    public final void update(List<Metric> metrics) {
        Preconditions.checkNotNull(metrics);
        try {
            this.updateImpl(metrics);
        }
        catch (Throwable t) {
            this.failedUpdateCount.incrementAndGet();
            throw Throwables.propagate((Throwable)t);
        }
        finally {
            this.updateCount.incrementAndGet();
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    protected final void incrementFailedCount() {
        this.failedUpdateCount.incrementAndGet();
    }

    public int getUpdateCount() {
        return this.updateCount.get();
    }

    public int getFailedUpdateCount() {
        return this.failedUpdateCount.get();
    }
}

