/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.base.Preconditions;
import com.netflix.servo.Metric;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.publish.BaseMetricObserver;
import com.netflix.servo.publish.MetricObserver;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncMetricObserver
extends BaseMetricObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncMetricObserver.class);
    private final MetricObserver wrappedObserver;
    private final long expireTime;
    private final BlockingQueue<TimestampedUpdate> updateQueue;
    @Monitor(name="UpdateExpiredCount", type=DataSourceType.COUNTER, description="Number of updates that expire in queue.")
    private final AtomicInteger expiredUpdateCount = new AtomicInteger(0);

    public AsyncMetricObserver(String name, MetricObserver observer, int queueSize, long expireTime) {
        super(name);
        this.expireTime = expireTime;
        this.wrappedObserver = (MetricObserver)Preconditions.checkNotNull((Object)observer);
        Preconditions.checkArgument((queueSize >= 1 ? 1 : 0) != 0, (String)"invalid queueSize %d, size must be >= 1", (Object[])new Object[]{queueSize});
        this.updateQueue = new LinkedBlockingDeque<TimestampedUpdate>(queueSize);
        String threadName = this.getClass().getSimpleName() + "-" + name;
        Thread processingThread = new Thread((Runnable)new UpdateProcessor(), threadName);
        processingThread.setDaemon(true);
        processingThread.start();
    }

    public AsyncMetricObserver(String name, MetricObserver observer) {
        this(name, observer, Integer.MAX_VALUE, Long.MAX_VALUE);
    }

    public AsyncMetricObserver(String name, MetricObserver observer, int queueSize) {
        this(name, observer, queueSize, Long.MAX_VALUE);
    }

    @Override
    public void updateImpl(List<Metric> metrics) {
        long now = System.currentTimeMillis();
        TimestampedUpdate update = new TimestampedUpdate(now, metrics);
        boolean result = this.updateQueue.offer(update);
        while (!result) {
            this.updateQueue.remove();
            result = this.updateQueue.offer(update);
        }
    }

    private void processUpdate() {
        try {
            TimestampedUpdate update = this.updateQueue.take();
            long cutoff = System.currentTimeMillis() - this.expireTime;
            if (update.getTimestamp() < cutoff) {
                this.expiredUpdateCount.incrementAndGet();
                return;
            }
            this.wrappedObserver.update(update.getMetrics());
        }
        catch (InterruptedException ie) {
            LOGGER.warn("interrupted while adding to queue, update dropped");
            this.incrementFailedCount();
        }
        catch (Throwable t) {
            LOGGER.warn("update failed for downstream queue", t);
            this.incrementFailedCount();
        }
    }

    private static class TimestampedUpdate {
        private final long timestamp;
        private final List<Metric> metrics;

        public TimestampedUpdate(long timestamp, List<Metric> metrics) {
            this.timestamp = timestamp;
            this.metrics = metrics;
        }

        long getTimestamp() {
            return this.timestamp;
        }

        List<Metric> getMetrics() {
            return this.metrics;
        }
    }

    private class UpdateProcessor
    implements Runnable {
        private UpdateProcessor() {
        }

        @Override
        public void run() {
            while (true) {
                AsyncMetricObserver.this.processUpdate();
            }
        }
    }
}

