/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.jmx;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.netflix.servo.annotations.AnnotatedAttribute;
import com.netflix.servo.annotations.AnnotatedObject;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.jmx.MetadataMBean;
import com.netflix.servo.jmx.MonitoredAttribute;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MonitoredResource
implements DynamicMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitoredResource.class);
    private final AnnotatedObject object;
    private final ObjectName name;
    private final MBeanInfo beanInfo;
    private final Map<String, MonitoredAttribute> attrs;
    private final MetadataMBean metadataMBean;

    public MonitoredResource(AnnotatedObject obj) {
        this(null, obj);
    }

    public MonitoredResource(String domain, AnnotatedObject obj) {
        this.object = (AnnotatedObject)Preconditions.checkNotNull((Object)obj, (Object)"object cannot be null");
        String className = this.object.getClassName();
        String id = this.object.getId();
        this.name = this.createObjectName(domain, className, id, "value");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        List<AnnotatedAttribute> annotatedAttrs = obj.getAttributes();
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[annotatedAttrs.size()];
        for (int i = 0; i < annotatedAttrs.size(); ++i) {
            MonitoredAttribute attr = new MonitoredAttribute(annotatedAttrs.get(i));
            Monitor m = attr.getAnnotation();
            builder.put((Object)m.name(), (Object)attr);
            attributes[i] = attr.getValueAttributeInfo();
        }
        this.attrs = builder.build();
        this.beanInfo = new MBeanInfo(className, "MonitoredResource MBean", attributes, null, null, null);
        ObjectName metadataName = this.createObjectName(domain, className, id, "metadata");
        MBeanInfo metadataInfo = new MBeanInfo(className, "MonitoredResource Metdata MBean", attributes, null, null, null);
        this.metadataMBean = new MetadataMBean(metadataName, metadataInfo, this.attrs);
    }

    private ObjectName createObjectName(String domain, String className, String id, String field) {
        StringBuilder buf = new StringBuilder();
        buf.append(domain == null ? this.getClass().getCanonicalName() : domain).append(":class=").append(className);
        if (id != null) {
            buf.append(",instance=").append(id);
        }
        buf.append(",field=").append(field);
        String name = buf.toString();
        try {
            return new ObjectName(buf.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("invalid ObjectName " + name, e);
        }
    }

    public ObjectName getObjectName() {
        return this.name;
    }

    public MetadataMBean getMetadataMBean() {
        return this.metadataMBean;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException {
        MonitoredAttribute attr = this.attrs.get(attribute);
        if (attr == null) {
            throw new AttributeNotFoundException(attribute);
        }
        try {
            return attr.getValue();
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (String a : attributes) {
            try {
                list.add(new Attribute(a, this.getAttribute(a)));
            }
            catch (Exception e) {
                LOGGER.warn("getAttribute() failed for " + a, (Throwable)e);
            }
        }
        return list;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.beanInfo;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) {
        throw new UnsupportedOperationException("invoke(...) is not supported on this mbean");
    }

    @Override
    public void setAttribute(Attribute attribute) {
        throw new UnsupportedOperationException("setAttribute(...) is not supported on this mbean");
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException("setAttributes(...) is not supported on this mbean");
    }
}

