/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.annotations;

import com.google.common.collect.ImmutableList;
import com.netflix.servo.annotations.AnnotatedAttribute;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.annotations.MonitorId;
import com.netflix.servo.annotations.MonitorTags;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.TagList;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

public final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static String getMonitorId(Object obj) throws Exception {
        List<AccessibleObject> fields = AnnotationUtils.getAnnotatedFields(MonitorId.class, obj, 1);
        return fields.isEmpty() ? null : (String)AnnotationUtils.getValue(obj, fields.get(0));
    }

    public static TagList getMonitorTags(Object obj) throws Exception {
        List<AccessibleObject> fields = AnnotationUtils.getAnnotatedFields(MonitorTags.class, obj, 1);
        return fields.isEmpty() ? BasicTagList.EMPTY : (TagList)AnnotationUtils.getValue(obj, fields.get(0));
    }

    public static List<AnnotatedAttribute> getMonitoredAttributes(Object obj) {
        List<AccessibleObject> fields = AnnotationUtils.getAnnotatedFields(Monitor.class, obj, Integer.MAX_VALUE);
        ImmutableList.Builder attrs = ImmutableList.builder();
        for (AccessibleObject field : fields) {
            Monitor m = field.getAnnotation(Monitor.class);
            attrs.add((Object)new AnnotatedAttribute(obj, m, field));
        }
        return attrs.build();
    }

    public static void validate(Object obj) {
        try {
            AnnotationUtils.getMonitorId(obj);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid MonitorId annotation on object " + obj, e);
        }
        try {
            AnnotationUtils.getMonitorTags(obj);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid MonitorTags annotation on object " + obj, e);
        }
        List<AnnotatedAttribute> attrs = AnnotationUtils.getMonitoredAttributes(obj);
        if (attrs.isEmpty()) {
            throw new IllegalArgumentException("no Monitor annotations on object " + obj);
        }
        String ctype = obj.getClass().getCanonicalName();
        for (AnnotatedAttribute attr : attrs) {
            String vtype;
            Monitor m = attr.getAnnotation();
            Object value = null;
            try {
                value = attr.getValue();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("failed to get value for " + m + " on " + ctype, e);
            }
            if (m.type() == DataSourceType.INFORMATIONAL) continue;
            String string = vtype = value == null ? null : value.getClass().getCanonicalName();
            Number n = AnnotationUtils.asNumber(value);
            if (n != null) continue;
            throw new IllegalArgumentException("expected java.lang.Number, but received " + vtype + " for " + m + " on " + ctype);
        }
    }

    public static Number asNumber(Object value) {
        Number num = null;
        if (value == null) {
            num = null;
        } else if (value instanceof Number) {
            num = (Number)value;
        } else if (value instanceof Boolean) {
            num = (Boolean)value != false ? 1 : 0;
        }
        return num;
    }

    public static Object getValue(Object obj, AccessibleObject attr) throws Exception {
        return attr instanceof Field ? ((Field)attr).get(obj) : ((Method)attr).invoke(obj, new Object[0]);
    }

    public static Number getNumber(Object obj, AccessibleObject attr) throws Exception {
        return AnnotationUtils.asNumber(AnnotationUtils.getValue(obj, attr));
    }

    private static List<AccessibleObject> getAnnotatedFields(Class<? extends Annotation> annotationClass, Object obj, int maxPerClass) {
        Annotation annotation;
        ImmutableList.Builder attrs = ImmutableList.builder();
        Class<?> objClass = obj.getClass();
        for (Field field : objClass.getDeclaredFields()) {
            annotation = field.getAnnotation(annotationClass);
            if (annotation == null) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            attrs.add((Object)field);
        }
        for (AccessibleObject accessibleObject : objClass.getDeclaredMethods()) {
            annotation = ((Method)accessibleObject).getAnnotation(annotationClass);
            if (annotation == null) continue;
            if (!accessibleObject.isAccessible()) {
                ((Method)accessibleObject).setAccessible(true);
            }
            attrs.add((Object)accessibleObject);
        }
        ImmutableList attrList = attrs.build();
        if (attrList.size() > maxPerClass) {
            throw new IllegalArgumentException(String.format("class %s has %d attributes annotated with %s", obj.getClass().getCanonicalName(), attrList.size(), annotationClass.getCanonicalName()));
        }
        return attrList;
    }
}

