/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.annotations;

import com.netflix.servo.annotations.AnnotationUtils;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import java.lang.reflect.AccessibleObject;

public final class AnnotatedAttribute {
    private final Object obj;
    private final Monitor anno;
    private final AccessibleObject attr;
    private final TagList tags;
    private final String[] tagsArray;

    public AnnotatedAttribute(Object obj, Monitor anno, AccessibleObject attr) {
        this(obj, anno, attr, BasicTagList.copyOf(anno.tags()));
    }

    public AnnotatedAttribute(Object obj, Monitor anno, AccessibleObject attr, TagList tags) {
        this.obj = obj;
        this.anno = anno;
        this.attr = attr;
        this.tags = tags;
        if (!attr.isAccessible()) {
            attr.setAccessible(true);
        }
        this.tagsArray = new String[tags.size()];
        int i = 0;
        for (Tag t : tags) {
            this.tagsArray[i] = t.getKey() + "=" + t.getValue();
            ++i;
        }
    }

    public Monitor getAnnotation() {
        return this.anno;
    }

    public AccessibleObject getAttribute() {
        return this.attr;
    }

    public TagList getTags() {
        return this.tags;
    }

    public String[] getTagsArray() {
        return this.tagsArray;
    }

    public Object getValue() throws Exception {
        return AnnotationUtils.getValue(this.obj, this.attr);
    }

    public Number getNumber() throws Exception {
        return AnnotationUtils.getNumber(this.obj, this.attr);
    }

    public AnnotatedAttribute copy(TagList classTags) {
        BasicTagList newTags = BasicTagList.concat(classTags, this.tags);
        return new AnnotatedAttribute(this.obj, this.anno, this.attr, newTags);
    }
}

