/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo;

import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.annotations.AnnotatedObject;
import com.netflix.servo.jmx.JmxMonitorRegistry;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultMonitorRegistry
implements MonitorRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMonitorRegistry.class);
    private static final String CLASS_NAME = DefaultMonitorRegistry.class.getCanonicalName();
    private static final String REGISTRY_CLASS_PROP = CLASS_NAME + ".registryClass";
    private static final MonitorRegistry INSTANCE = new DefaultMonitorRegistry();
    private final MonitorRegistry registry;

    public static MonitorRegistry getInstance() {
        return INSTANCE;
    }

    DefaultMonitorRegistry() {
        this(System.getProperties());
    }

    DefaultMonitorRegistry(Properties props) {
        String className = props.getProperty(REGISTRY_CLASS_PROP);
        if (className != null) {
            MonitorRegistry r = null;
            try {
                Class<?> c = Class.forName(className);
                r = (MonitorRegistry)c.newInstance();
            }
            catch (Throwable t) {
                LOGGER.error("failed to create instance of class " + className + ", " + "using default class " + JmxMonitorRegistry.class.getName(), t);
                r = new JmxMonitorRegistry();
            }
            this.registry = r;
        } else {
            this.registry = new JmxMonitorRegistry();
        }
    }

    @Override
    public void registerObject(Object obj) {
        this.registry.registerObject(obj);
    }

    @Override
    public void unRegisterObject(Object obj) {
        this.registry.unRegisterObject(obj);
    }

    @Override
    public Set<AnnotatedObject> getRegisteredObjects() {
        return this.registry.getRegisteredObjects();
    }

    MonitorRegistry getInnerRegistry() {
        return this.registry;
    }
}

