/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish.cloudwatch;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.google.common.base.Preconditions;
import com.netflix.servo.Metric;
import com.netflix.servo.publish.BaseMetricObserver;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudWatchMetricObserver
extends BaseMetricObserver {
    private static final Logger log = LoggerFactory.getLogger(CloudWatchMetricObserver.class);
    private int batchSize;
    private final AmazonCloudWatch cloudWatch;
    private final String cloudWatchNamespace;

    public CloudWatchMetricObserver(String string, String string2, AWSCredentials aWSCredentials) {
        super(string);
        this.cloudWatch = new AmazonCloudWatchClient(aWSCredentials);
        this.cloudWatchNamespace = string2;
        this.batchSize = 20;
    }

    public CloudWatchMetricObserver(String string, String string2, AWSCredentials aWSCredentials, int n) {
        this(string, string2, aWSCredentials);
        this.batchSize = n;
    }

    public void updateImpl(List<Metric> list) {
        Preconditions.checkNotNull(list);
        ArrayList<Metric> arrayList = new ArrayList<Metric>(this.batchSize);
        int n = 1;
        while (list.size() > 0) {
            Metric metric = list.remove(0);
            if (!metric.hasNumberValue()) continue;
            arrayList.add(metric);
            if (n++ % this.batchSize != 0) continue;
            this.cloudWatch.putMetricData(this.createPutRequest(arrayList));
            arrayList.clear();
        }
        if (!arrayList.isEmpty()) {
            this.cloudWatch.putMetricData(this.createPutRequest(arrayList));
        }
    }

    PutMetricDataRequest createPutRequest(List<Metric> list) {
        ArrayList<MetricDatum> arrayList = new ArrayList<MetricDatum>(list.size());
        for (Metric metric : list) {
            arrayList.add(this.createMetricDatum(metric));
        }
        return new PutMetricDataRequest().withNamespace(this.cloudWatchNamespace).withMetricData(arrayList);
    }

    MetricDatum createMetricDatum(Metric metric) {
        MetricDatum metricDatum = new MetricDatum();
        return metricDatum.withMetricName(metric.getConfig().getName()).withDimensions(this.createDimensions(metric.getConfig().getTags())).withUnit("None").withTimestamp(new Date(metric.getTimestamp())).withValue(Double.valueOf(metric.getNumberValue().doubleValue()));
    }

    List<Dimension> createDimensions(TagList tagList) {
        ArrayList<Dimension> arrayList = new ArrayList<Dimension>(tagList.size());
        for (Tag tag : tagList) {
            arrayList.add(new Dimension().withName(tag.getKey()).withValue(tag.getValue()));
        }
        return arrayList;
    }
}

