/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.tag.aws;

import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.AutoScalingInstanceDetails;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import com.netflix.servo.aws.AwsPropertyKeys;
import com.netflix.servo.aws.AwsServiceClients;
import com.netflix.servo.aws.constants.Dimensions;
import com.netflix.servo.tag.Tag;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AwsInjectableTag implements Tag
{
    AUTOSCALE_GROUP(Dimensions.AUTOSCALING_GROUP.getAwsString(), AwsInjectableTag.getAutoScaleGroup()),
    INSTANCE_ID(Dimensions.INSTANCE_ID.getAwsString(), AwsInjectableTag.getInstanceId()),
    AVAILABILITY_ZONE(Dimensions.AVAILABILITY_ZONE.getAwsString(), AwsInjectableTag.getZone()),
    AMI_ID(Dimensions.AMI_IMAGE_ID.getAwsString(), AwsInjectableTag.getAmiId()),
    INSTANCE_TYPE(Dimensions.INSTANCE_TYPE.getAwsString(), AwsInjectableTag.getInstanceType()),
    LOCAL_HOSTNAME("local-hostname", AwsInjectableTag.getLocalHostname()),
    LOCAL_IPV4("local-ipv4", AwsInjectableTag.getLocalIpv4()),
    PUBLIC_HOSTNAME("public-hostname", AwsInjectableTag.getPublicHostname()),
    PUBLIC_IPV4("public-ipv4", AwsInjectableTag.getPublicIpv4());

    private static final String METADATA_URL = "http://instance-data/latest/meta-data";
    private static final String UNDEFINED = "undefined";
    private final String key;
    private final String value;

    private static Logger getLogger() {
        return LoggerFactory.getLogger(AwsInjectableTag.class);
    }

    private AwsInjectableTag(String key, String val) {
        this.key = key;
        this.value = val;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String tagString() {
        return this.key + "=" + this.value;
    }

    static String getAutoScaleGroup() {
        try {
            String credFileProperty = System.getProperty(AwsPropertyKeys.AWS_CREDENTIALS_FILE.getBundle());
            Object credentials = credFileProperty != null ? new PropertiesCredentials(new File(credFileProperty)) : new DefaultAWSCredentialsProviderChain().getCredentials();
            AmazonAutoScaling autoScalingClient = AwsServiceClients.autoScaling(credentials);
            List autoScalingInstances = autoScalingClient.describeAutoScalingInstances(new DescribeAutoScalingInstancesRequest().withInstanceIds(new String[]{AwsInjectableTag.getInstanceId()})).getAutoScalingInstances();
            return autoScalingInstances.isEmpty() ? UNDEFINED : ((AutoScalingInstanceDetails)autoScalingInstances.get(0)).getAutoScalingGroupName();
        }
        catch (Exception e) {
            AwsInjectableTag.getLogger().error("Unable to get ASG name.", (Throwable)e);
            return UNDEFINED;
        }
    }

    static String getInstanceId() {
        return AwsInjectableTag.getUrlValue("/instance-id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getUrlValue(String path) {
        BufferedReader reader = null;
        try {
            URL url = new URL(METADATA_URL + path);
            reader = new BufferedReader(new InputStreamReader(url.openStream(), Charset.forName("UTF-8")));
            String string = reader.readLine();
            return string;
        }
        catch (Exception e) {
            AwsInjectableTag.getLogger().warn("Unable to read value from AWS metadata URL", (Throwable)e);
            String string = UNDEFINED;
            return string;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                AwsInjectableTag.getLogger().info("Ignoring failure while closing the stream", (Throwable)e);
            }
        }
    }

    static String getZone() {
        return AwsInjectableTag.getUrlValue("/placement/availability-zone");
    }

    static String getAmiId() {
        return AwsInjectableTag.getUrlValue("/ami-id");
    }

    static String getInstanceType() {
        return AwsInjectableTag.getUrlValue("/instance-type");
    }

    static String getLocalHostname() {
        return AwsInjectableTag.getUrlValue("/local-hostname");
    }

    static String getLocalIpv4() {
        return AwsInjectableTag.getUrlValue("/local-ipv4");
    }

    static String getPublicHostname() {
        return AwsInjectableTag.getUrlValue("/public-hostname");
    }

    static String getPublicIpv4() {
        return AwsInjectableTag.getUrlValue("/public-ipv4");
    }
}

