/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.http4;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.client.config.ClientConfigFactory;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.client.config.Property;
import com.netflix.http4.ConnectionPoolCleaner;
import com.netflix.http4.MonitoredConnectionManager;
import com.netflix.http4.NFHttpMethodRetryHandler;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NFHttpClient
extends DefaultHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(NFHttpClient.class);
    private static IClientConfigKey<Integer> RETRIES = new CommonClientConfigKey<Integer>("%s.nfhttpclient.retries", Integer.valueOf(3)){};
    private static IClientConfigKey<Integer> SLEEP_TIME_FACTOR_MS = new CommonClientConfigKey<Integer>("%s.nfhttpclient.sleepTimeFactorMs", Integer.valueOf(10)){};
    private static IClientConfigKey<Integer> CONN_IDLE_EVICT_TIME_MILLIS = new CommonClientConfigKey<Integer>("%s.nfhttpclient.connIdleEvictTimeMilliSeconds", Integer.valueOf(30000)){};
    protected static final String EXECUTE_TRACER = "HttpClient-ExecuteTimer";
    private static ScheduledExecutorService connectionPoolCleanUpScheduler;
    private HttpHost httpHost = null;
    private HttpRoute httpRoute = null;
    private static AtomicInteger numNonNamedHttpClients;
    private final String name;
    ConnectionPoolCleaner connPoolCleaner;
    Property<Integer> connIdleEvictTimeMilliSeconds;
    private Property<Integer> retriesProperty;
    private Property<Integer> sleepTimeFactorMsProperty;
    private Timer tracer;
    private Property<Integer> maxTotalConnectionProperty;
    private Property<Integer> maxConnectionPerHostProperty;

    protected NFHttpClient(String host, int port) {
        super((ClientConnectionManager)new ThreadSafeClientConnManager());
        this.name = "UNNAMED_" + numNonNamedHttpClients.incrementAndGet();
        this.httpHost = new HttpHost(host, port);
        this.httpRoute = new HttpRoute(this.httpHost);
        this.init(NFHttpClient.createDefaultConfig(), false);
    }

    protected NFHttpClient() {
        super((ClientConnectionManager)new ThreadSafeClientConnManager());
        this.name = "UNNAMED_" + numNonNamedHttpClients.incrementAndGet();
        this.init(NFHttpClient.createDefaultConfig(), false);
    }

    private static IClientConfig createDefaultConfig() {
        IClientConfig config = ClientConfigFactory.DEFAULT.newConfig();
        config.loadProperties("default");
        return config;
    }

    protected NFHttpClient(String name) {
        this(name, NFHttpClient.createDefaultConfig(), true);
    }

    protected NFHttpClient(String name, IClientConfig config) {
        this(name, config, true);
    }

    protected NFHttpClient(String name, IClientConfig config, boolean registerMonitor) {
        super((ClientConnectionManager)new MonitoredConnectionManager(name));
        this.name = name;
        this.init(config, registerMonitor);
    }

    void init(IClientConfig config, boolean registerMonitor) {
        HttpParams params = this.getParams();
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        params.setParameter("http.connection-manager.factory-class-name", (Object)ThreadSafeClientConnManager.class.getName());
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)((Boolean)config.get(CommonClientConfigKey.FollowRedirects, (Object)true)));
        ArrayList<BasicHeader> defaultHeaders = new ArrayList<BasicHeader>();
        defaultHeaders.add(new BasicHeader("Netflix.NFHttpClient.Version", "1.0"));
        defaultHeaders.add(new BasicHeader("X-netflix-httpclientname", this.name));
        params.setParameter("http.default-headers", defaultHeaders);
        this.connPoolCleaner = new ConnectionPoolCleaner(this.name, this.getConnectionManager(), connectionPoolCleanUpScheduler);
        this.retriesProperty = config.getGlobalProperty(RETRIES.format(new Object[]{this.name}));
        this.sleepTimeFactorMsProperty = config.getGlobalProperty(SLEEP_TIME_FACTOR_MS.format(new Object[]{this.name}));
        this.setHttpRequestRetryHandler((HttpRequestRetryHandler)new NFHttpMethodRetryHandler(this.name, (Integer)this.retriesProperty.getOrDefault(), false, (Integer)this.sleepTimeFactorMsProperty.getOrDefault()));
        this.tracer = Monitors.newTimer((String)("HttpClient-ExecuteTimer-" + this.name), (TimeUnit)TimeUnit.MILLISECONDS);
        if (registerMonitor) {
            Monitors.registerObject((String)this.name, (Object)((Object)this));
        }
        this.maxTotalConnectionProperty = config.getDynamicProperty(CommonClientConfigKey.MaxTotalHttpConnections);
        this.maxTotalConnectionProperty.onChange(newValue -> ((ThreadSafeClientConnManager)this.getConnectionManager()).setMaxTotal(newValue.intValue()));
        this.maxConnectionPerHostProperty = config.getDynamicProperty(CommonClientConfigKey.MaxHttpConnectionsPerHost);
        this.maxConnectionPerHostProperty.onChange(newValue -> ((ThreadSafeClientConnManager)this.getConnectionManager()).setDefaultMaxPerRoute(newValue.intValue()));
        this.connIdleEvictTimeMilliSeconds = config.getGlobalProperty(CONN_IDLE_EVICT_TIME_MILLIS.format(new Object[]{this.name}));
    }

    public void initConnectionCleanerTask() {
        this.connPoolCleaner.setConnIdleEvictTimeMilliSeconds(this.getConnIdleEvictTimeMilliSeconds());
        this.connPoolCleaner.initTask();
    }

    @Monitor(name="HttpClient-ConnPoolCleaner", type=DataSourceType.INFORMATIONAL)
    public ConnectionPoolCleaner getConnPoolCleaner() {
        return this.connPoolCleaner;
    }

    @Monitor(name="HttpClient-ConnIdleEvictTimeMilliSeconds", type=DataSourceType.INFORMATIONAL)
    public Property<Integer> getConnIdleEvictTimeMilliSeconds() {
        return this.connIdleEvictTimeMilliSeconds;
    }

    @Monitor(name="HttpClient-ConnectionsInPool", type=DataSourceType.GAUGE)
    public int getConnectionsInPool() {
        ClientConnectionManager connectionManager = this.getConnectionManager();
        if (connectionManager != null) {
            return ((ThreadSafeClientConnManager)connectionManager).getConnectionsInPool();
        }
        return 0;
    }

    @Monitor(name="HttpClient-MaxTotalConnections", type=DataSourceType.INFORMATIONAL)
    public int getMaxTotalConnnections() {
        ClientConnectionManager connectionManager = this.getConnectionManager();
        if (connectionManager != null) {
            return ((ThreadSafeClientConnManager)connectionManager).getMaxTotal();
        }
        return 0;
    }

    @Monitor(name="HttpClient-MaxConnectionsPerHost", type=DataSourceType.INFORMATIONAL)
    public int getMaxConnectionsPerHost() {
        ClientConnectionManager connectionManager = this.getConnectionManager();
        if (connectionManager != null) {
            if (this.httpRoute == null) {
                return ((ThreadSafeClientConnManager)connectionManager).getDefaultMaxPerRoute();
            }
            return ((ThreadSafeClientConnManager)connectionManager).getMaxForRoute(this.httpRoute);
        }
        return 0;
    }

    @Monitor(name="HttpClient-NumRetries", type=DataSourceType.INFORMATIONAL)
    public int getNumRetries() {
        return (Integer)this.retriesProperty.getOrDefault();
    }

    public void setConnIdleEvictTimeMilliSeconds(Property<Integer> connIdleEvictTimeMilliSeconds) {
        this.connIdleEvictTimeMilliSeconds = connIdleEvictTimeMilliSeconds;
    }

    @Monitor(name="HttpClient-SleepTimeFactorMs", type=DataSourceType.INFORMATIONAL)
    public int getSleepTimeFactorMs() {
        return (Integer)this.sleepTimeFactorMsProperty.getOrDefault();
    }

    private static HttpHost determineTarget(HttpUriRequest request) throws ClientProtocolException {
        HttpHost target = null;
        URI requestURI = request.getURI();
        if (requestURI.isAbsolute() && (target = URIUtils.extractHost((URI)requestURI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + requestURI);
        }
        return target;
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.execute(request, responseHandler, null);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        HttpHost target = null;
        target = this.httpHost == null ? NFHttpClient.determineTarget(request) : this.httpHost;
        return this.execute(target, (HttpRequest)request, responseHandler, context);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.execute(target, request, responseHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        Stopwatch sw = this.tracer.start();
        try {
            LOGGER.debug("Executing HTTP method: {}, uri: {}", (Object)request.getRequestLine().getMethod(), (Object)request.getRequestLine().getUri());
            Object object = super.execute(target, request, responseHandler, context);
            return (T)object;
        }
        finally {
            sw.stop();
        }
    }

    public void shutdown() {
        if (this.connPoolCleaner != null) {
            this.connPoolCleaner.shutdown();
        }
        this.getConnectionManager().shutdown();
    }

    static {
        numNonNamedHttpClients = new AtomicInteger();
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Connection pool clean up thread").build();
        connectionPoolCleanUpScheduler = Executors.newScheduledThreadPool(2, factory);
    }
}

