/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.niws.client.http;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import com.netflix.client.ClientException;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.http.HttpHeaders;
import com.netflix.client.http.HttpResponse;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

class HttpClientResponse
implements HttpResponse {
    private final ClientResponse bcr;
    private final Multimap<String, String> headers = ArrayListMultimap.create();
    private final HttpHeaders httpHeaders;
    private final URI requestedURI;
    private final IClientConfig overrideConfig;

    public HttpClientResponse(ClientResponse cr, URI requestedURI, IClientConfig config) {
        this.bcr = cr;
        this.requestedURI = requestedURI;
        this.overrideConfig = config;
        for (Map.Entry entry : this.bcr.getHeaders().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.headers.putAll(entry.getKey(), (Iterable)entry.getValue());
        }
        this.httpHeaders = new HttpHeaders(){

            @Override
            public String getFirstValue(String headerName) {
                return (String)HttpClientResponse.this.bcr.getHeaders().getFirst((Object)headerName);
            }

            @Override
            public List<String> getAllValues(String headerName) {
                return (List)HttpClientResponse.this.bcr.getHeaders().get((Object)headerName);
            }

            @Override
            public List<Map.Entry<String, String>> getAllHeaders() {
                MultivaluedMap map = HttpClientResponse.this.bcr.getHeaders();
                ArrayList result = Lists.newArrayList();
                for (Map.Entry header : map.entrySet()) {
                    String name = (String)header.getKey();
                    for (String value : (List)header.getValue()) {
                        result.add(new AbstractMap.SimpleEntry<String, String>(name, value));
                    }
                }
                return result;
            }

            @Override
            public boolean containsHeader(String name) {
                return HttpClientResponse.this.bcr.getHeaders().containsKey((Object)name);
            }
        };
    }

    public InputStream getRawEntity() {
        return this.bcr.getEntityInputStream();
    }

    @Override
    public <T> T getEntity(Class<T> c) throws Exception {
        return (T)this.bcr.getEntity(c);
    }

    @Override
    public Map<String, Collection<String>> getHeaders() {
        return this.headers.asMap();
    }

    @Override
    public int getStatus() {
        return this.bcr.getStatus();
    }

    public boolean isSuccess() {
        ClientResponse.Status s;
        boolean isSuccess = false;
        ClientResponse.Status status = s = this.bcr != null ? this.bcr.getClientResponseStatus() : null;
        isSuccess = s != null ? s.getFamily() == Response.Status.Family.SUCCESSFUL : false;
        return isSuccess;
    }

    public boolean hasEntity() {
        return this.bcr.hasEntity();
    }

    public URI getRequestedURI() {
        return this.requestedURI;
    }

    public Object getPayload() throws ClientException {
        if (this.hasEntity()) {
            return this.getRawEntity();
        }
        return null;
    }

    public boolean hasPayload() {
        return this.hasEntity();
    }

    public ClientResponse getJerseyClientResponse() {
        return this.bcr;
    }

    @Override
    public void close() {
        this.bcr.close();
    }

    @Override
    public InputStream getInputStream() {
        return this.getRawEntity();
    }

    @Override
    public String getStatusLine() {
        return this.bcr.getClientResponseStatus().toString();
    }

    @Override
    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    @Override
    public <T> T getEntity(TypeToken<T> type) throws Exception {
        return (T)this.bcr.getEntity(new GenericType(type.getType()));
    }

    @Override
    public <T> T getEntity(Type type) throws Exception {
        return (T)this.bcr.getEntity(new GenericType(type));
    }
}

