/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client.http;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.netflix.client.ClientRequest;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.http.CaseInsensitiveMultiMap;
import com.netflix.client.http.HttpHeaders;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;

public class HttpRequest
extends ClientRequest {
    protected CaseInsensitiveMultiMap httpHeaders = new CaseInsensitiveMultiMap();
    protected Multimap<String, String> queryParams = ArrayListMultimap.create();
    private Object entity;
    protected Verb verb = Verb.GET;

    HttpRequest() {
    }

    public Map<String, Collection<String>> getQueryParams() {
        return this.queryParams.asMap();
    }

    public Verb getVerb() {
        return this.verb;
    }

    @Deprecated
    public Map<String, Collection<String>> getHeaders() {
        return this.httpHeaders.asMap();
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public Object getEntity() {
        return this.entity;
    }

    public boolean isRetriable() {
        if (this.verb == Verb.GET && this.isRetriable == null) {
            return true;
        }
        return super.isRetriable();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(HttpRequest toCopy) {
        return new Builder(toCopy);
    }

    public HttpRequest replaceUri(URI newURI) {
        return new Builder().uri(newURI).headers(this.httpHeaders).overrideConfig(this.getOverrideConfig()).queryParams(this.queryParams).setRetriable(this.isRetriable()).loadBalancerKey(this.getLoadBalancerKey()).verb(this.getVerb()).build();
    }

    public static class Builder {
        private HttpRequest request = new HttpRequest();

        public Builder() {
        }

        public Builder(HttpRequest request) {
            this.request = request;
        }

        public Builder uri(URI uri) {
            this.request.setUri(uri);
            return this;
        }

        public Builder uri(String uri) {
            try {
                this.request.setUri(new URI(uri));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder header(String name, String value) {
            this.request.httpHeaders.addHeader(name, value);
            return this;
        }

        Builder queryParams(Multimap<String, String> queryParams) {
            this.request.queryParams = queryParams;
            return this;
        }

        @Deprecated
        public Builder overrideConfig(IClientConfig config) {
            this.request.setOverrideConfig(config);
            return this;
        }

        Builder headers(CaseInsensitiveMultiMap headers) {
            this.request.httpHeaders = headers;
            return this;
        }

        public Builder setRetriable(boolean retriable) {
            this.request.setRetriable(retriable);
            return this;
        }

        @Deprecated
        public Builder queryParams(String name, String value) {
            this.request.queryParams.put((Object)name, (Object)value);
            return this;
        }

        public Builder queryParam(String name, String value) {
            this.request.queryParams.put((Object)name, (Object)value);
            return this;
        }

        public Builder entity(Object entity) {
            this.request.entity = entity;
            return this;
        }

        public Builder verb(Verb verb) {
            this.request.verb = verb;
            return this;
        }

        public Builder loadBalancerKey(Object loadBalancerKey) {
            this.request.setLoadBalancerKey(loadBalancerKey);
            return this;
        }

        public HttpRequest build() {
            return this.request;
        }
    }

    public static enum Verb {
        GET("GET"),
        PUT("PUT"),
        POST("POST"),
        DELETE("DELETE"),
        OPTIONS("OPTIONS"),
        HEAD("HEAD");

        private final String verb;

        private Verb(String verb) {
            this.verb = verb;
        }

        public String verb() {
            return this.verb;
        }
    }
}

