/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.niws.client.http;

import com.netflix.client.AbstractLoadBalancerAwareClient;
import com.netflix.client.ClientException;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.client.http.HttpRequest;
import com.netflix.client.http.HttpResponse;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.http4.NFHttpClient;
import com.netflix.http4.NFHttpClientFactory;
import com.netflix.http4.NFHttpMethodRetryHandler;
import com.netflix.http4.ssl.KeyStoreAwareSocketFactory;
import com.netflix.niws.cert.AbstractSslContextFactory;
import com.netflix.niws.client.ClientSslSocketFactoryException;
import com.netflix.niws.client.URLSslContextFactory;
import com.netflix.niws.client.http.HttpClientResponse;
import com.netflix.util.Pair;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.ApacheHttpClient4Handler;
import com.sun.jersey.client.apache4.config.ApacheHttpClient4Config;
import com.sun.jersey.client.apache4.config.DefaultApacheHttpClient4Config;
import java.io.File;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.KeyStore;
import java.util.Collection;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient
extends AbstractLoadBalancerAwareClient<HttpRequest, HttpResponse> {
    private Client restClient;
    private HttpClient httpClient4;
    private IClientConfig ncc;
    private String restClientName;
    private boolean enableConnectionPoolCleanerTask = false;
    private DynamicIntProperty connIdleEvictTimeMilliSeconds;
    private int connectionCleanerRepeatInterval;
    private int maxConnectionsperHost;
    private int maxTotalConnections;
    private int connectionTimeout;
    private int readTimeout;
    private String proxyHost;
    private int proxyPort;
    private boolean isSecure;
    private boolean isHostnameValidationRequired;
    private boolean isClientAuthRequired;
    private boolean ignoreUserToken;
    private ApacheHttpClient4Config config;
    boolean bFollowRedirects = DefaultClientConfigImpl.DEFAULT_FOLLOW_REDIRECTS;
    private static final Logger logger = LoggerFactory.getLogger(RestClient.class);

    public RestClient() {
        this.restClientName = "default";
    }

    public RestClient(IClientConfig ncc) {
        this.initWithNiwsConfig(ncc);
    }

    public RestClient(Client jerseyClient) {
        this.restClient = jerseyClient;
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        super.initWithNiwsConfig(clientConfig);
        this.ncc = clientConfig;
        this.restClientName = this.ncc.getClientName();
        this.isSecure = this.getBooleanFromConfig(this.ncc, (IClientConfigKey)CommonClientConfigKey.IsSecure, this.isSecure);
        this.isHostnameValidationRequired = this.getBooleanFromConfig(this.ncc, (IClientConfigKey)CommonClientConfigKey.IsHostnameValidationRequired, this.isHostnameValidationRequired);
        this.isClientAuthRequired = this.getBooleanFromConfig(this.ncc, (IClientConfigKey)CommonClientConfigKey.IsClientAuthRequired, this.isClientAuthRequired);
        this.bFollowRedirects = this.getBooleanFromConfig(this.ncc, (IClientConfigKey)CommonClientConfigKey.FollowRedirects, true);
        this.ignoreUserToken = this.getBooleanFromConfig(this.ncc, (IClientConfigKey)CommonClientConfigKey.IgnoreUserTokenInConnectionPoolForSecureClient, this.ignoreUserToken);
        this.config = new DefaultApacheHttpClient4Config();
        this.config.getProperties().put("com.sun.jersey.client.property.connectTimeout", Integer.parseInt(String.valueOf(this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.ConnectTimeout))));
        this.config.getProperties().put("com.sun.jersey.client.property.readTimeout", Integer.parseInt(String.valueOf(this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.ReadTimeout))));
        this.restClient = this.apacheHttpClientSpecificInitialization();
    }

    protected Client apacheHttpClientSpecificInitialization() {
        ClientConnectionManager connMgr;
        this.httpClient4 = NFHttpClientFactory.getNamedNFHttpClient(this.restClientName, true);
        if (this.httpClient4 instanceof AbstractHttpClient) {
            ((AbstractHttpClient)this.httpClient4).setHttpRequestRetryHandler((HttpRequestRetryHandler)new NFHttpMethodRetryHandler(this.restClientName, 0, false, 0));
        } else {
            logger.warn("Unexpected error: Unable to disable NFHttpClient retry handler, this most likely will not cause an issue but probably should be looked at");
        }
        HttpParams httpClientParams = this.httpClient4.getParams();
        NFHttpClient nfHttpClient = (NFHttpClient)this.httpClient4;
        try {
            this.enableConnectionPoolCleanerTask = Boolean.parseBoolean(this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.ConnectionPoolCleanerTaskEnabled, (Object)false).toString());
            nfHttpClient.getConnPoolCleaner().setEnableConnectionPoolCleanerTask(this.enableConnectionPoolCleanerTask);
        }
        catch (Exception e1) {
            throw new IllegalArgumentException("Invalid value for property:" + CommonClientConfigKey.ConnectionPoolCleanerTaskEnabled, e1);
        }
        if (this.enableConnectionPoolCleanerTask) {
            try {
                this.connectionCleanerRepeatInterval = Integer.parseInt(String.valueOf(this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.ConnectionCleanerRepeatInterval, (Object)30000)));
                nfHttpClient.getConnPoolCleaner().setConnectionCleanerRepeatInterval(this.connectionCleanerRepeatInterval);
            }
            catch (Exception e1) {
                throw new IllegalArgumentException("Invalid value for property:" + CommonClientConfigKey.ConnectionCleanerRepeatInterval, e1);
            }
            try {
                int iConnIdleEvictTimeMilliSeconds = Integer.parseInt("" + this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.ConnIdleEvictTimeMilliSeconds, (Object)30000));
                this.connIdleEvictTimeMilliSeconds = DynamicPropertyFactory.getInstance().getIntProperty(this.restClientName + ".nfhttpclient.connIdleEvictTimeMilliSeconds", iConnIdleEvictTimeMilliSeconds);
                nfHttpClient.setConnIdleEvictTimeMilliSeconds(this.connIdleEvictTimeMilliSeconds);
            }
            catch (Exception e1) {
                throw new IllegalArgumentException("Invalid value for property:" + CommonClientConfigKey.ConnIdleEvictTimeMilliSeconds, e1);
            }
            nfHttpClient.initConnectionCleanerTask();
        }
        try {
            this.maxConnectionsperHost = Integer.parseInt("" + this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.MaxHttpConnectionsPerHost, (Object)this.maxConnectionsperHost));
            connMgr = this.httpClient4.getConnectionManager();
            if (connMgr instanceof ThreadSafeClientConnManager) {
                ((ThreadSafeClientConnManager)connMgr).setDefaultMaxPerRoute(this.maxConnectionsperHost);
            }
        }
        catch (Exception e1) {
            throw new IllegalArgumentException("Invalid value for property:" + CommonClientConfigKey.MaxHttpConnectionsPerHost, e1);
        }
        try {
            this.maxTotalConnections = Integer.parseInt("" + this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.MaxTotalHttpConnections, (Object)this.maxTotalConnections));
            connMgr = this.httpClient4.getConnectionManager();
            if (connMgr instanceof ThreadSafeClientConnManager) {
                ((ThreadSafeClientConnManager)connMgr).setMaxTotal(this.maxTotalConnections);
            }
        }
        catch (Exception e1) {
            throw new IllegalArgumentException("Invalid value for property:" + CommonClientConfigKey.MaxTotalHttpConnections, e1);
        }
        try {
            this.connectionTimeout = Integer.parseInt("" + this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.ConnectTimeout, (Object)this.connectionTimeout));
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpClientParams, (int)this.connectionTimeout);
        }
        catch (Exception e1) {
            throw new IllegalArgumentException("Invalid value for property:" + CommonClientConfigKey.ConnectTimeout, e1);
        }
        try {
            this.readTimeout = Integer.parseInt("" + this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.ReadTimeout, (Object)this.readTimeout));
            HttpConnectionParams.setSoTimeout((HttpParams)httpClientParams, (int)this.readTimeout);
        }
        catch (Exception e1) {
            throw new IllegalArgumentException("Invalid value for property:" + CommonClientConfigKey.ReadTimeout, e1);
        }
        int bufferSize = Integer.MIN_VALUE;
        if (this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.ReceiveBuffferSize) != null) {
            try {
                bufferSize = Integer.parseInt("" + this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.ReceiveBuffferSize));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid value for property:" + CommonClientConfigKey.ReceiveBuffferSize, e);
            }
            if (this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.SendBufferSize) != null) {
                try {
                    int sendBufferSize = Integer.parseInt("" + this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.SendBufferSize));
                    if (sendBufferSize > bufferSize) {
                        bufferSize = sendBufferSize;
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid value for property:" + CommonClientConfigKey.SendBufferSize, e);
                }
            }
        }
        if (bufferSize != Integer.MIN_VALUE) {
            HttpConnectionParams.setSocketBufferSize((HttpParams)httpClientParams, (int)bufferSize);
        }
        if (this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.StaleCheckingEnabled) != null) {
            try {
                HttpConnectionParams.setStaleCheckingEnabled((HttpParams)httpClientParams, (boolean)Boolean.parseBoolean(this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.StaleCheckingEnabled, (Object)false).toString()));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid value for property:" + CommonClientConfigKey.StaleCheckingEnabled, e);
            }
        }
        if (this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.Linger) != null) {
            try {
                HttpConnectionParams.setLinger((HttpParams)httpClientParams, (int)Integer.parseInt("" + this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.Linger)));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid value for property:" + CommonClientConfigKey.Linger, e);
            }
        }
        if (this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.ProxyHost) != null) {
            try {
                this.proxyHost = (String)this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.ProxyHost);
                this.proxyPort = Integer.parseInt("" + this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.ProxyPort));
                HttpHost proxy = new HttpHost(this.proxyHost, this.proxyPort);
                this.httpClient4.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid value for property:" + CommonClientConfigKey.ProxyHost, e);
            }
        }
        if (this.isSecure) {
            URL trustStoreUrl = this.getResourceForOptionalProperty((IClientConfigKey)CommonClientConfigKey.TrustStore);
            URL keyStoreUrl = this.getResourceForOptionalProperty((IClientConfigKey)CommonClientConfigKey.KeyStore);
            ClientConnectionManager currentManager = this.httpClient4.getConnectionManager();
            URLSslContextFactory abstractFactory = null;
            if (this.isClientAuthRequired && trustStoreUrl != null && keyStoreUrl != null || !this.isClientAuthRequired && (trustStoreUrl != null || keyStoreUrl != null)) {
                try {
                    abstractFactory = new URLSslContextFactory(trustStoreUrl, (String)this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.TrustStorePassword), keyStoreUrl, (String)this.ncc.getProperty((IClientConfigKey)CommonClientConfigKey.KeyStorePassword));
                }
                catch (ClientSslSocketFactoryException e) {
                    throw new IllegalArgumentException("Unable to configure custom secure socket factory", e);
                }
            }
            try {
                KeyStoreAwareSocketFactory awareSocketFactory = this.isHostnameValidationRequired ? new KeyStoreAwareSocketFactory(abstractFactory) : new KeyStoreAwareSocketFactory(abstractFactory, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                currentManager.getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)awareSocketFactory));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to configure custom secure socket factory", e);
            }
        }
        if (this.ignoreUserToken) {
            ((DefaultHttpClient)this.httpClient4).setUserTokenHandler(new UserTokenHandler(){

                public Object getUserToken(HttpContext context) {
                    return null;
                }
            });
        }
        ApacheHttpClient4Handler handler = new ApacheHttpClient4Handler(this.httpClient4, (CookieStore)new BasicCookieStore(), false);
        return new ApacheHttpClient4(handler, (ClientConfig)this.config);
    }

    public void resetSSLSocketFactory(AbstractSslContextFactory abstractContextFactory) {
        try {
            KeyStoreAwareSocketFactory awareSocketFactory = this.isHostnameValidationRequired ? new KeyStoreAwareSocketFactory(abstractContextFactory) : new KeyStoreAwareSocketFactory(abstractContextFactory, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            this.httpClient4.getConnectionManager().getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)awareSocketFactory));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to configure custom secure socket factory", e);
        }
    }

    public KeyStore getKeyStore() {
        SchemeRegistry registry = this.httpClient4.getConnectionManager().getSchemeRegistry();
        if (!registry.getSchemeNames().contains("https")) {
            throw new IllegalStateException("Registry does not include an 'https' entry.");
        }
        SchemeSocketFactory awareSocketFactory = this.httpClient4.getConnectionManager().getSchemeRegistry().getScheme("https").getSchemeSocketFactory();
        if (awareSocketFactory instanceof KeyStoreAwareSocketFactory) {
            return ((KeyStoreAwareSocketFactory)awareSocketFactory).getKeyStore();
        }
        throw new IllegalStateException("Cannot extract keystore from scheme socket factory of type: " + awareSocketFactory.getClass().getName());
    }

    public static URL getResource(String resourceName) {
        URL url = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            url = loader.getResource(resourceName);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(resourceName);
        }
        if (url == null) {
            url = ConfigurationManager.class.getResource(resourceName);
        }
        if (url == null) {
            url = ConfigurationManager.class.getClassLoader().getResource(resourceName);
        }
        if (url == null) {
            try {
                resourceName = URLDecoder.decode(resourceName, "UTF-8");
                url = new File(resourceName).toURI().toURL();
            }
            catch (Exception e) {
                logger.error("Problem loading resource", (Throwable)e);
            }
        }
        return url;
    }

    public Client getJerseyClient() {
        return this.restClient;
    }

    public void setJerseyClient(Client c) {
        this.restClient = c;
    }

    private URL getResourceForOptionalProperty(IClientConfigKey configKey) {
        String propValue = (String)this.ncc.getProperty(configKey);
        URL result = null;
        if (propValue != null && (result = RestClient.getResource(propValue)) == null) {
            throw new IllegalArgumentException("No resource found for " + configKey + ": " + propValue);
        }
        return result;
    }

    public HttpResponse execute(HttpRequest task) throws Exception {
        return this.execute(task.getVerb(), task.getUri(), task.getHeaders(), task.getQueryParams(), task.getOverrideConfig(), task.getEntity());
    }

    private boolean getBooleanFromConfig(IClientConfig overriddenClientConfig, IClientConfigKey key, boolean defaultValue) {
        if (overriddenClientConfig != null && overriddenClientConfig.containsProperty(key)) {
            defaultValue = Boolean.parseBoolean(overriddenClientConfig.getProperty(key).toString());
        }
        return defaultValue;
    }

    protected int getDefaultPortFromScheme(String scheme) {
        int port = super.getDefaultPortFromScheme(scheme);
        if (port < 0) {
            return 80;
        }
        return port;
    }

    protected Pair<String, Integer> deriveSchemeAndPortFromPartialUri(HttpRequest task) {
        int port;
        URI theUrl = task.getUri();
        boolean isSecure = this.getBooleanFromConfig(task.getOverrideConfig(), (IClientConfigKey)CommonClientConfigKey.IsSecure, this.isSecure);
        String scheme = theUrl.getScheme();
        if (scheme != null) {
            isSecure = scheme.equalsIgnoreCase("https");
        }
        if ((port = theUrl.getPort()) < 0 && !isSecure) {
            port = 80;
        } else if (port < 0 && isSecure) {
            port = 443;
        }
        if (scheme == null) {
            scheme = isSecure ? "https" : "http";
        }
        return new Pair((Object)scheme, (Object)port);
    }

    private HttpResponse execute(HttpRequest.Verb verb, URI uri, Map<String, Collection<String>> headers, Map<String, Collection<String>> params, IClientConfig overriddenClientConfig, Object requestEntity) throws Exception {
        ClientResponse jerseyResponse;
        HttpClientResponse thisResponse = null;
        boolean bbFollowRedirects = this.bFollowRedirects;
        if (overriddenClientConfig != null && overriddenClientConfig.getProperty((IClientConfigKey)CommonClientConfigKey.FollowRedirects) != null) {
            Boolean followRedirects = Boolean.valueOf("" + overriddenClientConfig.getProperty((IClientConfigKey)CommonClientConfigKey.FollowRedirects, (Object)this.bFollowRedirects));
            bbFollowRedirects = followRedirects;
        }
        this.restClient.setFollowRedirects(Boolean.valueOf(bbFollowRedirects));
        if (logger.isDebugEnabled()) {
            logger.debug("RestClient sending new Request(" + verb + ": ) " + uri);
        }
        WebResource xResource = this.restClient.resource(uri.toString());
        if (params != null) {
            for (Map.Entry<String, Collection<String>> entry : params.entrySet()) {
                String name = entry.getKey();
                for (String value : entry.getValue()) {
                    xResource = xResource.queryParam(name, value);
                }
            }
        }
        WebResource.Builder b = xResource.getRequestBuilder();
        if (headers != null) {
            for (Map.Entry<String, Collection<String>> entry : headers.entrySet()) {
                String name = entry.getKey();
                for (String value : entry.getValue()) {
                    b = (WebResource.Builder)b.header(name, (Object)value);
                }
            }
        }
        switch (verb) {
            case GET: {
                jerseyResponse = (ClientResponse)b.get(ClientResponse.class);
                break;
            }
            case POST: {
                jerseyResponse = (ClientResponse)b.post(ClientResponse.class, requestEntity);
                break;
            }
            case PUT: {
                jerseyResponse = (ClientResponse)b.put(ClientResponse.class, requestEntity);
                break;
            }
            case DELETE: {
                jerseyResponse = (ClientResponse)b.delete(ClientResponse.class, requestEntity);
                break;
            }
            case HEAD: {
                jerseyResponse = b.head();
                break;
            }
            case OPTIONS: {
                jerseyResponse = (ClientResponse)b.options(ClientResponse.class);
                break;
            }
            default: {
                throw new ClientException(ClientException.ErrorType.GENERAL, "You have to one of the REST verbs such as GET, POST etc.");
            }
        }
        thisResponse = new HttpClientResponse(jerseyResponse);
        thisResponse.setRequestedURI(uri);
        if (thisResponse.getStatus() == 503) {
            thisResponse.close();
            throw new ClientException(ClientException.ErrorType.SERVER_THROTTLED);
        }
        return thisResponse;
    }

    protected boolean isRetriableException(Throwable e) {
        if (e instanceof ClientException && ((ClientException)e).getErrorType() == ClientException.ErrorType.SERVER_THROTTLED) {
            return false;
        }
        boolean shouldRetry = RestClient.isConnectException(e) || RestClient.isSocketException(e);
        return shouldRetry;
    }

    protected boolean isCircuitBreakerException(Throwable e) {
        ClientException clientException;
        if (e instanceof ClientException && (clientException = (ClientException)e).getErrorType() == ClientException.ErrorType.SERVER_THROTTLED) {
            return true;
        }
        return RestClient.isConnectException(e) || RestClient.isSocketException(e);
    }

    private static boolean isSocketException(Throwable e) {
        for (int levelCount = 0; e != null && levelCount < 10; e = e.getCause(), ++levelCount) {
            if (!(e instanceof SocketException) && !(e instanceof SocketTimeoutException)) continue;
            return true;
        }
        return false;
    }

    private static boolean isConnectException(Throwable e) {
        for (int levelCount = 0; e != null && levelCount < 10; e = e.getCause(), ++levelCount) {
            if (!(e instanceof SocketException) && (!(e instanceof ConnectTimeoutException) || e instanceof ConnectionPoolTimeoutException)) continue;
            return true;
        }
        return false;
    }

    protected Pair<String, Integer> deriveHostAndPortFromVipAddress(String vipAddress) throws URISyntaxException, ClientException {
        if (!vipAddress.contains("http")) {
            vipAddress = "http://" + vipAddress;
        }
        return super.deriveHostAndPortFromVipAddress(vipAddress);
    }
}

