/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.niws.client.http;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import com.netflix.client.ClientException;
import com.netflix.client.http.HttpResponse;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.core.Response;

class HttpClientResponse
implements HttpResponse {
    private ClientResponse bcr = null;
    private URI requestedURI;
    private Multimap<String, String> headers = ArrayListMultimap.create();

    public HttpClientResponse(ClientResponse cr) {
        this.bcr = cr;
        for (Map.Entry entry : this.bcr.getHeaders().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.headers.putAll(entry.getKey(), (Iterable)entry.getValue());
        }
    }

    public InputStream getRawEntity() throws ClientException {
        return this.bcr.getEntityInputStream();
    }

    public <T> T getEntity(Class<T> c) throws Exception {
        Object t = null;
        try {
            t = this.bcr.getEntity(c);
        }
        catch (UniformInterfaceException e) {
            throw new ClientException(ClientException.ErrorType.GENERAL, e.getMessage(), e.getCause());
        }
        return (T)t;
    }

    public Map<String, Collection<String>> getHeaders() {
        return this.headers.asMap();
    }

    public int getStatus() {
        return this.bcr.getStatus();
    }

    public boolean isSuccess() {
        ClientResponse.Status s;
        boolean isSuccess = false;
        ClientResponse.Status status = s = this.bcr != null ? this.bcr.getClientResponseStatus() : null;
        isSuccess = s != null ? s.getFamily() == Response.Status.Family.SUCCESSFUL : false;
        return isSuccess;
    }

    public boolean hasEntity() {
        return this.bcr.hasEntity();
    }

    public URI getRequestedURI() {
        return this.requestedURI;
    }

    public void setRequestedURI(URI requestedURI) {
        this.requestedURI = requestedURI;
    }

    public Object getPayload() throws ClientException {
        if (this.hasEntity()) {
            return this.getRawEntity();
        }
        return null;
    }

    public boolean hasPayload() {
        return this.hasEntity();
    }

    public ClientResponse getJerseyClientResponse() {
        return this.bcr;
    }

    public void close() {
        this.bcr.close();
    }

    public <T> T getEntity(TypeToken<T> type) throws Exception {
        return this.getEntity(type.getRawType());
    }

    public InputStream getInputStream() throws ClientException {
        return this.getRawEntity();
    }
}

