/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.http4;

import com.netflix.http4.NFHttpClient;
import com.netflix.servo.monitor.Monitors;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.apache.http.client.HttpClient;

public class NFHttpClientFactory {
    private static Map<MultiKey, NFHttpClient> clientMap = new ConcurrentHashMap<MultiKey, NFHttpClient>();
    private static Map<String, NFHttpClient> namedClientMap = new ConcurrentHashMap<String, NFHttpClient>();
    private static NFHttpClient defaultClient = new NFHttpClient();
    private static Object lock = new Object();

    public static NFHttpClient getNFHttpClient(String host, int port) {
        MultiKey mk = new MultiKey((Object)host, (Object)port);
        NFHttpClient client = clientMap.get(mk);
        if (client == null) {
            client = new NFHttpClient(host, port);
            clientMap.put(mk, client);
        }
        return client;
    }

    public static NFHttpClient getNamedNFHttpClient(String name) {
        return NFHttpClientFactory.getNamedNFHttpClient(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NFHttpClient getNamedNFHttpClient(String name, boolean registerMonitor) {
        NFHttpClient client = namedClientMap.get(name);
        if (client == null) {
            Object object = lock;
            synchronized (object) {
                client = namedClientMap.get(name);
                if (client == null) {
                    client = new NFHttpClient(name);
                    namedClientMap.put(name, client);
                    if (registerMonitor) {
                        Monitors.registerObject((String)("HttpClient_" + name), (Object)((Object)client));
                    }
                }
            }
        }
        return client;
    }

    public static NFHttpClient getDefaultClient() {
        return defaultClient;
    }

    public static void setDefaultClient(NFHttpClient defaultClient) {
        NFHttpClientFactory.defaultClient = defaultClient;
    }

    public static void shutdownNFHttpClient(String name) {
        HttpClient c = (HttpClient)namedClientMap.get(name);
        if (c != null) {
            c.getConnectionManager().shutdown();
            namedClientMap.remove(name);
            Monitors.unregisterObject((String)("HttpClient_" + name), (Object)c);
        }
    }
}

