/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.niws.client.http;

import com.netflix.client.ClientException;
import com.netflix.client.IResponse;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientResponse
implements IResponse {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientResponse.class);
    private ClientResponse bcr = null;
    private URI requestedURI;

    public HttpClientResponse(ClientResponse cr) {
        this.bcr = cr;
    }

    public InputStream getRawEntity() throws ClientException {
        return this.bcr.getEntityInputStream();
    }

    public <T> T getEntity(Class<T> c) throws Exception {
        Object t = null;
        try {
            t = this.bcr.getEntity(c);
        }
        catch (UniformInterfaceException e) {
            throw new ClientException(ClientException.ErrorType.GENERAL, e.getMessage(), e.getCause());
        }
        return (T)t;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.bcr.getHeaders();
    }

    public int getStatus() {
        return this.bcr.getStatus();
    }

    public boolean isSuccess() {
        ClientResponse.Status s;
        boolean isSuccess = false;
        ClientResponse.Status status = s = this.bcr != null ? this.bcr.getClientResponseStatus() : null;
        isSuccess = s != null ? s.getFamily() == Response.Status.Family.SUCCESSFUL : false;
        return isSuccess;
    }

    public boolean hasEntity() {
        return this.bcr.hasEntity();
    }

    public URI getRequestedURI() {
        return this.requestedURI;
    }

    public void setRequestedURI(URI requestedURI) {
        this.requestedURI = requestedURI;
    }

    public Object getPayload() throws ClientException {
        if (this.hasEntity()) {
            return this.getRawEntity();
        }
        return null;
    }

    public boolean hasPayload() {
        return this.hasEntity();
    }

    public ClientResponse getJerseyClientResponse() {
        return this.bcr;
    }

    public void releaseResources() {
        try {
            this.bcr.close();
        }
        catch (Exception e) {
            logger.error("Error releasing connection", (Throwable)e);
        }
    }
}

