/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.http4;

import com.google.common.base.Preconditions;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.ConnPoolByRoute;
import org.apache.http.impl.conn.tsccm.PoolEntryRequest;
import org.apache.http.impl.conn.tsccm.RouteSpecificPool;
import org.apache.http.impl.conn.tsccm.WaitingThreadAborter;
import org.apache.http.params.HttpParams;

public class NamedConnectionPool
extends ConnPoolByRoute {
    private Counter freeEntryCounter;
    private Counter createEntryCounter;
    private Counter requestCounter;
    private Counter releaseCounter;
    private Counter deleteCounter;
    private Stopwatch requestTimer;

    public NamedConnectionPool(String name, ClientConnectionOperator operator, ConnPerRoute connPerRoute, int maxTotalConnections, long connTTL, TimeUnit connTTLTimeUnit) {
        super(operator, connPerRoute, maxTotalConnections, connTTL, connTTLTimeUnit);
        this.initMonitors(name);
    }

    public NamedConnectionPool(String name, ClientConnectionOperator operator, ConnPerRoute connPerRoute, int maxTotalConnections) {
        super(operator, connPerRoute, maxTotalConnections);
        this.initMonitors(name);
    }

    public NamedConnectionPool(String name, ClientConnectionOperator operator, HttpParams params) {
        super(operator, params);
        this.initMonitors(name);
    }

    NamedConnectionPool(ClientConnectionOperator operator, ConnPerRoute connPerRoute, int maxTotalConnections, long connTTL, TimeUnit connTTLTimeUnit) {
        super(operator, connPerRoute, maxTotalConnections, connTTL, connTTLTimeUnit);
    }

    NamedConnectionPool(ClientConnectionOperator operator, ConnPerRoute connPerRoute, int maxTotalConnections) {
        super(operator, connPerRoute, maxTotalConnections);
    }

    NamedConnectionPool(ClientConnectionOperator operator, HttpParams params) {
        super(operator, params);
    }

    void initMonitors(String name) {
        Preconditions.checkNotNull((Object)name);
        this.freeEntryCounter = Monitors.newCounter((String)(name + "_Reuse"));
        this.createEntryCounter = Monitors.newCounter((String)(name + "_CreateNew"));
        this.requestCounter = Monitors.newCounter((String)(name + "_Request"));
        this.releaseCounter = Monitors.newCounter((String)(name + "_Release"));
        this.deleteCounter = Monitors.newCounter((String)(name + "_Delete"));
        this.requestTimer = Monitors.newTimer((String)(name + "RequestEntry"), (TimeUnit)TimeUnit.MILLISECONDS).start();
        this.requestTimer.reset();
        Monitors.registerObject((Object)((Object)this));
    }

    public PoolEntryRequest requestPoolEntry(HttpRoute route, Object state) {
        this.requestCounter.increment();
        return super.requestPoolEntry(route, state);
    }

    protected BasicPoolEntry getFreeEntry(RouteSpecificPool rospl, Object state) {
        BasicPoolEntry entry = super.getFreeEntry(rospl, state);
        if (entry != null) {
            this.freeEntryCounter.increment();
        }
        return entry;
    }

    protected BasicPoolEntry createEntry(RouteSpecificPool rospl, ClientConnectionOperator op) {
        this.createEntryCounter.increment();
        return super.createEntry(rospl, op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BasicPoolEntry getEntryBlocking(HttpRoute route, Object state, long timeout, TimeUnit tunit, WaitingThreadAborter aborter) throws ConnectionPoolTimeoutException, InterruptedException {
        this.requestTimer.start();
        try {
            BasicPoolEntry basicPoolEntry = super.getEntryBlocking(route, state, timeout, tunit, aborter);
            return basicPoolEntry;
        }
        finally {
            this.requestTimer.stop();
        }
    }

    public void freeEntry(BasicPoolEntry entry, boolean reusable, long validDuration, TimeUnit timeUnit) {
        this.releaseCounter.increment();
        super.freeEntry(entry, reusable, validDuration, timeUnit);
    }

    protected void deleteEntry(BasicPoolEntry entry) {
        this.deleteCounter.increment();
        super.deleteEntry(entry);
    }

    public final long getFreeEntryCount() {
        return (Long)this.freeEntryCounter.getValue();
    }

    public final long getCreatedEntryCount() {
        return (Long)this.createEntryCounter.getValue();
    }

    public final long getRequestsCount() {
        return (Long)this.requestCounter.getValue();
    }

    public final long getReleaseCount() {
        return (Long)this.releaseCounter.getValue();
    }

    public final long getDeleteCount() {
        return (Long)this.deleteCounter.getValue();
    }
}

