/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples.rx.transport;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.ribbon.examples.rx.AbstractRxMovieClient;
import com.netflix.ribbon.examples.rx.common.Movie;
import com.netflix.ribbon.examples.rx.common.RxMovieTransformer;
import com.netflix.ribbon.transport.netty.RibbonTransport;
import com.netflix.ribbon.transport.netty.http.LoadBalancingHttpClient;
import io.netty.buffer.ByteBuf;
import io.reactivex.netty.channel.ContentTransformer;
import io.reactivex.netty.channel.StringTransformer;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import rx.Observable;
import rx.functions.Func1;

public class RxMovieTransportExample
extends AbstractRxMovieClient {
    private final LoadBalancingHttpClient<ByteBuf, ByteBuf> client;

    public RxMovieTransportExample(int port) {
        IClientConfig clientConfig = IClientConfig.Builder.newBuilder((String)"movieServiceClient").build();
        clientConfig.set(CommonClientConfigKey.ListOfServers, (Object)("localhost:" + port));
        this.client = RibbonTransport.newHttpClient((IClientConfig)clientConfig);
    }

    @Override
    protected Observable<ByteBuf>[] triggerMoviesRegistration() {
        return new Observable[]{this.registerMovie(Movie.ORANGE_IS_THE_NEW_BLACK), this.registerMovie(Movie.BREAKING_BAD), this.registerMovie(Movie.HOUSE_OF_CARDS)};
    }

    private Observable<Void> registerMovie(Movie movie) {
        HttpClientRequest httpRequest = HttpClientRequest.createPost((String)"/movies").withHeader("X-Platform-Version", "xyz").withHeader("X-Auth-Token", "abc").withRawContentSource(Observable.just((Object)movie), (ContentTransformer)new RxMovieTransformer());
        return this.client.submit(httpRequest).flatMap((Func1)new Func1<HttpClientResponse<ByteBuf>, Observable<Void>>(){

            public Observable<Void> call(HttpClientResponse<ByteBuf> httpClientResponse) {
                if (httpClientResponse.getStatus().code() / 100 != 2) {
                    return Observable.error((Throwable)new RuntimeException(String.format("HTTP request failed (status code=%s)", httpClientResponse.getStatus())));
                }
                return Observable.empty();
            }
        });
    }

    @Override
    protected Observable<ByteBuf>[] triggerRecommendationsUpdate() {
        return new Observable[]{this.updateRecommendation("user1", Movie.ORANGE_IS_THE_NEW_BLACK), this.updateRecommendation("user1", Movie.BREAKING_BAD)};
    }

    private Observable<Void> updateRecommendation(String user, Movie movie) {
        HttpClientRequest httpRequest = HttpClientRequest.createPost((String)String.format("/users/%s/recommendations", user)).withHeader("X-Platform-Version", "xyz").withHeader("X-Auth-Token", "abc").withRawContentSource(Observable.just((Object)movie.getId()), (ContentTransformer)new StringTransformer());
        return this.client.submit(httpRequest).flatMap((Func1)new Func1<HttpClientResponse<ByteBuf>, Observable<Void>>(){

            public Observable<Void> call(HttpClientResponse<ByteBuf> httpClientResponse) {
                if (httpClientResponse.getStatus().code() / 100 != 2) {
                    return Observable.error((Throwable)new RuntimeException(String.format("HTTP request failed (status code=%s)", httpClientResponse.getStatus())));
                }
                return Observable.empty();
            }
        });
    }

    @Override
    protected Observable<ByteBuf>[] triggerRecommendationsSearch() {
        HttpClientRequest httpRequest = HttpClientRequest.createGet((String)String.format("/users/%s/recommendations", "user1")).withHeader("X-Platform-Version", "xyz").withHeader("X-Auth-Token", "abc");
        Observable searchByUserObservable = this.client.submit(httpRequest).flatMap((Func1)new Func1<HttpClientResponse<ByteBuf>, Observable<ByteBuf>>(){

            public Observable<ByteBuf> call(HttpClientResponse<ByteBuf> httpClientResponse) {
                if (httpClientResponse.getStatus().code() / 100 != 2) {
                    return Observable.error((Throwable)new RuntimeException(String.format("HTTP request failed (status code=%s)", httpClientResponse.getStatus())));
                }
                return httpClientResponse.getContent();
            }
        });
        httpRequest = HttpClientRequest.createGet((String)"/recommendations?category=Drama&ageGroup=Adults").withHeader("X-Platform-Version", "xyz").withHeader("X-Auth-Token", "abc");
        Observable searchByCriteriaObservable = this.client.submit(httpRequest).flatMap((Func1)new Func1<HttpClientResponse<ByteBuf>, Observable<ByteBuf>>(){

            public Observable<ByteBuf> call(HttpClientResponse<ByteBuf> httpClientResponse) {
                if (httpClientResponse.getStatus().code() / 100 != 2) {
                    return Observable.error((Throwable)new RuntimeException(String.format("HTTP request failed (status code=%s)", httpClientResponse.getStatus())));
                }
                return httpClientResponse.getContent();
            }
        });
        return new Observable[]{searchByUserObservable, searchByCriteriaObservable};
    }

    public static void main(String[] args) {
        System.out.println("Starting transport based movie service...");
        new RxMovieTransportExample(8080).runExample();
    }
}

