/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples.rx.common;

import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Movie {
    private static final Pattern FORMAT_RE = Pattern.compile("\\{id='([^']*)', name='([^']*)', category='([^']*)', ageGroup='([^']*)', contentURI='([^']*)'\\}");
    public static final Movie ORANGE_IS_THE_NEW_BLACK = new Movie("1", "Orange is the New Black", "Drama", "Adults", "http://streaming.netflix.com/movies?id=1");
    public static final Movie BREAKING_BAD = new Movie("2", "Breaking Bad", "Crime", "Adults", "http://streaming.netflix.com/movies?id=2");
    public static final Movie HOUSE_OF_CARDS = new Movie("3", "House of Cards", "Political", "Adults", "http://streaming.netflix.com/movies?id=3");
    private final String id;
    private final String name;
    private final String category;
    private final String ageGroup;
    private final String contentURI;

    public Movie(String id, String name, String category, String ageGroup, String contentURI) {
        this.id = id;
        this.name = name;
        this.category = category;
        this.ageGroup = ageGroup;
        this.contentURI = contentURI;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public String getContentURI() {
        return this.contentURI;
    }

    public String getAgeGroup() {
        return this.ageGroup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Movie movie = (Movie)o;
        if (this.ageGroup != null ? !this.ageGroup.equals(movie.ageGroup) : movie.ageGroup != null) {
            return false;
        }
        if (this.category != null ? !this.category.equals(movie.category) : movie.category != null) {
            return false;
        }
        if (this.contentURI != null ? !this.contentURI.equals(movie.contentURI) : movie.contentURI != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(movie.id) : movie.id != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(movie.name) : movie.name != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
        result = 31 * result + (this.ageGroup != null ? this.ageGroup.hashCode() : 0);
        result = 31 * result + (this.contentURI != null ? this.contentURI.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", category='" + this.category + '\'' + ", ageGroup='" + this.ageGroup + '\'' + ", contentURI='" + this.contentURI + '\'' + '}';
    }

    public static Movie from(String formatted) {
        Matcher matcher = FORMAT_RE.matcher(formatted);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Syntax error in movie string: " + formatted);
        }
        return new Movie(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5));
    }

    public static Movie from(ByteBuf byteBuf) {
        return Movie.from(byteBuf.toString(Charset.defaultCharset()));
    }
}

