/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples.rx.proxy;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.config.ConfigurationManager;
import com.netflix.ribbon.Ribbon;
import com.netflix.ribbon.examples.rx.AbstractRxMovieClient;
import com.netflix.ribbon.examples.rx.common.Movie;
import com.netflix.ribbon.examples.rx.proxy.MovieService;
import com.netflix.ribbon.proxy.ProxyLifeCycle;
import io.netty.buffer.ByteBuf;
import rx.Observable;

public class RxMovieProxyExample
extends AbstractRxMovieClient {
    private final MovieService movieService;

    public RxMovieProxyExample(int port) {
        ConfigurationManager.getConfigInstance().setProperty("MovieService.ribbon." + CommonClientConfigKey.MaxAutoRetriesNextServer, (Object)"3");
        ConfigurationManager.getConfigInstance().setProperty("MovieService.ribbon." + CommonClientConfigKey.ListOfServers, (Object)("localhost:" + port));
        this.movieService = (MovieService)Ribbon.from(MovieService.class);
    }

    @Override
    protected Observable<ByteBuf>[] triggerMoviesRegistration() {
        return new Observable[]{this.movieService.registerMovie(Movie.ORANGE_IS_THE_NEW_BLACK).toObservable(), this.movieService.registerMovie(Movie.BREAKING_BAD).toObservable(), this.movieService.registerMovie(Movie.HOUSE_OF_CARDS).toObservable()};
    }

    @Override
    protected Observable<ByteBuf>[] triggerRecommendationsUpdate() {
        return new Observable[]{this.movieService.updateRecommendations("user1", Movie.ORANGE_IS_THE_NEW_BLACK.getId()).toObservable(), this.movieService.updateRecommendations("user1", Movie.BREAKING_BAD.getId()).toObservable()};
    }

    @Override
    protected Observable<ByteBuf>[] triggerRecommendationsSearch() {
        return new Observable[]{this.movieService.recommendationsByUserId("user1").toObservable(), this.movieService.recommendationsBy("Drama", "Adults").toObservable()};
    }

    @Override
    public void shutdown() {
        super.shutdown();
        ((ProxyLifeCycle)this.movieService).shutdown();
    }

    public static void main(String[] args) {
        System.out.println("Starting proxy based movie service...");
        new RxMovieProxyExample(8080).runExample();
    }
}

