/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples.netty.http;

import com.google.common.collect.Lists;
import com.netflix.loadbalancer.BaseLoadBalancer;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.LoadBalancerBuilder;
import com.netflix.loadbalancer.Server;
import com.netflix.ribbon.transport.netty.RibbonTransport;
import com.netflix.ribbon.transport.netty.http.LoadBalancingHttpClient;
import io.netty.buffer.ByteBuf;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import rx.Observer;

public class LoadBalancingExample {
    public static void main(String[] args) throws Exception {
        ArrayList servers = Lists.newArrayList((Object[])new Server[]{new Server("www.google.com:80"), new Server("www.examples.com:80"), new Server("www.wikipedia.org:80")});
        BaseLoadBalancer lb = LoadBalancerBuilder.newBuilder().buildFixedServerListLoadBalancer((List)servers);
        LoadBalancingHttpClient client = RibbonTransport.newHttpClient((ILoadBalancer)lb);
        final CountDownLatch latch = new CountDownLatch(servers.size());
        Observer<HttpClientResponse<ByteBuf>> observer = new Observer<HttpClientResponse<ByteBuf>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                e.printStackTrace();
            }

            public void onNext(HttpClientResponse<ByteBuf> args) {
                latch.countDown();
                System.out.println("Got response: " + args.getStatus());
            }
        };
        for (int i = 0; i < servers.size(); ++i) {
            HttpClientRequest request = HttpClientRequest.createGet((String)"/");
            client.submit(request).subscribe((Observer)observer);
        }
        latch.await();
        System.out.println(lb.getLoadBalancerStats());
    }
}

