/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples.rx.template;

import com.netflix.ribbon.ClientOptions;
import com.netflix.ribbon.ResponseValidator;
import com.netflix.ribbon.Ribbon;
import com.netflix.ribbon.examples.rx.AbstractRxMovieClient;
import com.netflix.ribbon.examples.rx.common.Movie;
import com.netflix.ribbon.examples.rx.common.RecommendationServiceFallbackHandler;
import com.netflix.ribbon.examples.rx.common.RecommendationServiceResponseValidator;
import com.netflix.ribbon.examples.rx.common.RxMovieTransformer;
import com.netflix.ribbon.http.HttpRequestTemplate;
import com.netflix.ribbon.http.HttpResourceGroup;
import com.netflix.ribbon.hystrix.FallbackHandler;
import io.netty.buffer.ByteBuf;
import io.reactivex.netty.channel.ContentTransformer;
import io.reactivex.netty.channel.StringTransformer;
import rx.Observable;

public class RxMovieTemplateExample
extends AbstractRxMovieClient {
    private final HttpResourceGroup httpResourceGroup = Ribbon.createHttpResourceGroup((String)"movieServiceClient", (ClientOptions)ClientOptions.create().withMaxAutoRetriesNextServer(3).withConfigurationBasedServerList("localhost:8080"));
    private final HttpRequestTemplate<Void> registerMovieTemplate = this.httpResourceGroup.newRequestTemplate("registerMovie", Void.class).withMethod("POST").withUriTemplate("/movies").withHeader("X-Platform-Version", "xyz").withHeader("X-Auth-Token", "abc").withResponseValidator((ResponseValidator)new RecommendationServiceResponseValidator());
    private final HttpRequestTemplate<Void> updateRecommendationTemplate = this.httpResourceGroup.newRequestTemplate("updateRecommendation", Void.class).withMethod("POST").withUriTemplate("/users/{userId}/recommendations").withHeader("X-Platform-Version", "xyz").withHeader("X-Auth-Token", "abc").withResponseValidator((ResponseValidator)new RecommendationServiceResponseValidator());
    private final HttpRequestTemplate<ByteBuf> recommendationsByUserIdTemplate = this.httpResourceGroup.newRequestTemplate("recommendationsByUserId", ByteBuf.class).withMethod("GET").withUriTemplate("/users/{userId}/recommendations").withHeader("X-Platform-Version", "xyz").withHeader("X-Auth-Token", "abc").withFallbackProvider((FallbackHandler)new RecommendationServiceFallbackHandler()).withResponseValidator((ResponseValidator)new RecommendationServiceResponseValidator());
    private final HttpRequestTemplate<ByteBuf> recommendationsByTemplate = this.httpResourceGroup.newRequestTemplate("recommendationsBy", ByteBuf.class).withMethod("GET").withUriTemplate("/recommendations?category={category}&ageGroup={ageGroup}").withHeader("X-Platform-Version", "xyz").withHeader("X-Auth-Token", "abc").withFallbackProvider((FallbackHandler)new RecommendationServiceFallbackHandler()).withResponseValidator((ResponseValidator)new RecommendationServiceResponseValidator());

    @Override
    protected Observable<Void>[] triggerMoviesRegistration() {
        return new Observable[]{this.registerMovieTemplate.requestBuilder().withRawContentSource(Observable.just((Object)Movie.ORANGE_IS_THE_NEW_BLACK), (ContentTransformer)new RxMovieTransformer()).build().observe(), this.registerMovieTemplate.requestBuilder().withRawContentSource(Observable.just((Object)Movie.BREAKING_BAD), (ContentTransformer)new RxMovieTransformer()).build().observe(), this.registerMovieTemplate.requestBuilder().withRawContentSource(Observable.just((Object)Movie.HOUSE_OF_CARDS), (ContentTransformer)new RxMovieTransformer()).build().observe()};
    }

    @Override
    protected Observable<Void>[] triggerRecommendationsUpdate() {
        return new Observable[]{this.updateRecommendationTemplate.requestBuilder().withRawContentSource(Observable.just((Object)Movie.ORANGE_IS_THE_NEW_BLACK.getId()), (ContentTransformer)new StringTransformer()).withRequestProperty("userId", (Object)"user1").build().observe(), this.updateRecommendationTemplate.requestBuilder().withRawContentSource(Observable.just((Object)Movie.BREAKING_BAD.getId()), (ContentTransformer)new StringTransformer()).withRequestProperty("userId", (Object)"user1").build().observe()};
    }

    @Override
    protected Observable<ByteBuf>[] triggerRecommendationsSearch() {
        return new Observable[]{this.recommendationsByUserIdTemplate.requestBuilder().withRequestProperty("userId", (Object)"user1").build().observe(), this.recommendationsByTemplate.requestBuilder().withRequestProperty("category", (Object)"Drama").withRequestProperty("ageGroup", (Object)"Adults").build().observe()};
    }

    public static void main(String[] args) {
        System.out.println("Starting templates based movie service...");
        new RxMovieTemplateExample().execute();
    }
}

