/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples.rx;

import com.netflix.hystrix.util.HystrixTimer;
import com.netflix.ribbon.examples.rx.common.Movie;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import rx.Notification;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

public abstract class AbstractRxMovieClient {
    protected static final String TEST_USER = "user1";
    protected static final Pattern NEW_LINE_SPLIT_RE = Pattern.compile("\n");

    protected abstract Observable<Void>[] triggerMoviesRegistration();

    protected abstract Observable<Void>[] triggerRecommendationsUpdate();

    protected abstract Observable<ByteBuf>[] triggerRecommendationsSearch();

    protected boolean registerMovies() {
        System.out.print("Registering movies...");
        Notification status = (Notification)Observable.concat((Observable)Observable.from((Object[])this.triggerMoviesRegistration())).materialize().toBlocking().last();
        if (status.isOnError()) {
            System.err.println("ERROR");
            status.getThrowable().printStackTrace();
            return false;
        }
        System.out.println("DONE");
        return true;
    }

    protected boolean updateRecommendations() {
        System.out.print("Updating user recommendations...");
        Notification status = (Notification)Observable.concat((Observable)Observable.from((Object[])this.triggerRecommendationsUpdate())).materialize().toBlocking().last();
        if (status.isOnError()) {
            System.err.println("ERROR");
            status.getThrowable().printStackTrace();
            return false;
        }
        System.out.println("DONE");
        return true;
    }

    protected boolean searchCatalog() {
        System.out.println("Searching through the movie catalog...");
        ArrayList searches = new ArrayList(2);
        Collections.addAll(searches, "findById", "findRawMovieById", "findMovie(name, category)");
        Notification status = (Notification)Observable.concat((Observable)Observable.from((Object[])this.triggerRecommendationsSearch())).flatMap((Func1)new Func1<ByteBuf, Observable<List<Movie>>>(){

            public Observable<List<Movie>> call(ByteBuf byteBuf) {
                ArrayList<Movie> movies = new ArrayList<Movie>();
                String lines = byteBuf.toString(Charset.defaultCharset());
                for (String line : NEW_LINE_SPLIT_RE.split(lines)) {
                    movies.add(Movie.from(line));
                }
                return Observable.just(movies);
            }
        }).zip(searches, (Func2)new Func2<List<Movie>, String, Void>(){

            public Void call(List<Movie> movies, String query) {
                System.out.println(String.format("    %s=%s", query, movies));
                return null;
            }
        }).materialize().toBlocking().last();
        if (status.isOnError()) {
            System.err.println("ERROR");
            status.getThrowable().printStackTrace();
            return false;
        }
        System.out.println("DONE");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            if (this.registerMovies() && this.updateRecommendations() && this.searchCatalog()) {
                System.out.println("Application finished");
            } else {
                System.err.println("ERROR: execution failure");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.shutdown();
        }
    }

    protected void shutdown() {
        HystrixTimer.reset();
    }
}

