/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples;

import com.netflix.client.StreamDecoder;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SSEDecoder
implements StreamDecoder<String, ByteBuffer> {
    public String decode(ByteBuffer input) throws IOException {
        if (input == null || !input.hasRemaining()) {
            return null;
        }
        byte[] buffer = new byte[input.limit()];
        boolean foundDelimiter = false;
        int index = 0;
        int start = input.position();
        while (input.remaining() > 0) {
            byte b = input.get();
            if (b == 10 || b == 13) {
                foundDelimiter = true;
                break;
            }
            buffer[index++] = b;
        }
        if (!foundDelimiter) {
            input.position(start);
            return null;
        }
        if (index == 0) {
            return null;
        }
        return new String(buffer, 0, index, "UTF-8");
    }
}

