/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples;

import com.google.common.collect.Lists;
import com.netflix.client.AsyncBackupRequestsExecutor;
import com.netflix.client.AsyncClient;
import com.netflix.client.BufferedResponseCallback;
import com.netflix.client.http.AsyncHttpClient;
import com.netflix.client.http.AsyncHttpClientBuilder;
import com.netflix.client.http.BufferedHttpResponseCallback;
import com.netflix.client.http.HttpRequest;
import com.netflix.client.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ExecutionWithBackupRequestExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        AsyncHttpClient client = AsyncHttpClientBuilder.withApacheAsyncClient().buildClient();
        try {
            ArrayList requests = Lists.newArrayList((Object[])new HttpRequest[]{HttpRequest.newBuilder().uri("http://www.microsoft.com/").build(), HttpRequest.newBuilder().uri("http://www.google.com/").build()});
            System.out.println("Try with 100ms timeout");
            AsyncBackupRequestsExecutor.ExecutionResult results = AsyncBackupRequestsExecutor.executeWithBackupRequests((AsyncClient)client, (List)requests, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS, (BufferedResponseCallback)new BufferedHttpResponseCallback(){

                public void failed(Throwable e) {
                }

                public void completed(HttpResponse response) {
                    System.out.println("Get response from server: " + response.getRequestedURI().getHost());
                }

                public void cancelled() {
                }
            });
            Thread.sleep(2000L);
            System.out.println("URIs tried: " + results.getAllAttempts().keySet());
            System.out.println("Callback invoked on URI: " + results.getExecutedURI());
            System.out.println("Try with 2000ms timeout");
            results = AsyncBackupRequestsExecutor.executeWithBackupRequests((AsyncClient)client, (List)requests, (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS, (BufferedResponseCallback)new BufferedHttpResponseCallback(){

                public void failed(Throwable e) {
                }

                public void completed(HttpResponse response) {
                    System.out.println("Get response from server: " + response.getRequestedURI().getHost());
                }

                public void cancelled() {
                }
            });
            Thread.sleep(2000L);
            System.out.println("URIs tried: " + results.getAllAttempts().keySet());
            System.out.println("Callback invoked on URI: " + results.getExecutedURI());
        }
        finally {
            client.close();
        }
    }
}

