/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples;

import com.google.common.collect.Lists;
import com.netflix.client.AsyncBackupRequestsExecutor;
import com.netflix.client.BufferedResponseCallback;
import com.netflix.client.ClientRequest;
import com.netflix.client.ResponseCallback;
import com.netflix.client.http.AsyncHttpClientBuilder;
import com.netflix.client.http.AsyncLoadBalancingHttpClient;
import com.netflix.client.http.BufferedHttpResponseCallback;
import com.netflix.client.http.HttpRequest;
import com.netflix.client.http.HttpResponse;
import com.netflix.loadbalancer.AbstractLoadBalancer;
import com.netflix.loadbalancer.Server;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AsyncLoadBalancingClientExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        AsyncLoadBalancingHttpClient client = AsyncHttpClientBuilder.withApacheAsyncClient().balancingWithServerList((List)Lists.newArrayList((Object[])new Server[]{new Server("www.google.com", 80), new Server("www.microsoft.com", 80), new Server("www.yahoo.com", 80)})).build();
        try {
            HttpRequest request = HttpRequest.newBuilder().uri("/").build();
            for (int i = 0; i < 6; ++i) {
                client.execute((ClientRequest)request, (BufferedResponseCallback)new BufferedHttpResponseCallback(){

                    public void completed(HttpResponse response) {
                        System.out.println("Get response from server: " + response.getRequestedURI().getHost());
                    }

                    public void failed(Throwable e) {
                        System.err.println(e);
                    }

                    public void cancelled() {
                    }
                });
            }
            Thread.sleep(5000L);
            System.out.println("Server stats: " + ((AbstractLoadBalancer)client.getLoadBalancer()).getLoadBalancerStats());
            AsyncBackupRequestsExecutor.ExecutionResult result = client.executeWithBackupRequests((ClientRequest)request, 3, 100L, TimeUnit.MILLISECONDS, null, (ResponseCallback)new BufferedHttpResponseCallback(){

                public void failed(Throwable e) {
                }

                public void completed(HttpResponse response) {
                    System.out.println("Get first response from server: " + response.getRequestedURI().getHost());
                }

                public void cancelled() {
                }
            });
            Thread.sleep(5000L);
            System.out.println("URIs tried in execution with backup requests: " + result.getAllAttempts().keySet());
            System.out.println("Executed URI in execution with backup requests: " + result.getExecutedURI());
        }
        finally {
            client.close();
        }
    }
}

