/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples;

import com.netflix.client.BufferedResponseCallback;
import com.netflix.client.ClientRequest;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.client.http.AsyncBufferingHttpClient;
import com.netflix.client.http.AsyncHttpClientBuilder;
import com.netflix.client.http.HttpRequest;
import com.netflix.client.http.HttpResponse;
import com.netflix.ribbon.examples.ExampleAppWithLocalResource;
import com.netflix.ribbon.examples.GsonSerializationFactory;
import com.netflix.ribbon.examples.XStreamFactory;
import com.netflix.ribbon.examples.server.ServerResources;
import com.netflix.serialization.SerializationFactory;
import java.net.URI;
import java.util.concurrent.Future;

public class CustomizedClientExample
extends ExampleAppWithLocalResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        URI uri = new URI(this.SERVICE_URI + "testAsync/person");
        DefaultClientConfigImpl clientConfig = DefaultClientConfigImpl.getClientConfigWithDefaultValues();
        clientConfig.setProperty((IClientConfigKey)CommonClientConfigKey.ConnectTimeout, (Object)"1000");
        clientConfig.setProperty((IClientConfigKey)CommonClientConfigKey.ReadTimeout, (Object)"1000");
        HttpRequest request = HttpRequest.newBuilder().uri(uri).build();
        AsyncBufferingHttpClient client = AsyncHttpClientBuilder.withApacheAsyncClient((IClientConfig)clientConfig).buildBufferingClient();
        client.addSerializationFactory((SerializationFactory)new GsonSerializationFactory());
        client.addSerializationFactory((SerializationFactory)new XStreamFactory());
        try {
            Future future = client.execute((ClientRequest)request, (BufferedResponseCallback)new BufferedResponseCallback<HttpResponse>(){

                public void failed(Throwable e) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void completed(HttpResponse response) {
                    try {
                        ServerResources.Person person = (ServerResources.Person)response.getEntity(ServerResources.Person.class);
                        System.out.println(person);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        response.close();
                    }
                }

                public void cancelled() {
                }
            });
            future.get();
            request = HttpRequest.newBuilder().uri(this.SERVICE_URI + "testAsync/getXml").build();
            future = client.execute((ClientRequest)request, (BufferedResponseCallback)new BufferedResponseCallback<HttpResponse>(){

                public void failed(Throwable e) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void completed(HttpResponse response) {
                    try {
                        ServerResources.Person person = (ServerResources.Person)response.getEntity(ServerResources.Person.class);
                        System.out.println(person);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        response.close();
                    }
                }

                public void cancelled() {
                }
            });
            future.get();
        }
        finally {
            client.close();
        }
    }

    public static void main(String[] args) throws Exception {
        CustomizedClientExample app = new CustomizedClientExample();
        app.runApp();
    }
}

