/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples;

import com.netflix.client.BufferedResponseCallback;
import com.netflix.client.ClientRequest;
import com.netflix.client.http.AsyncBufferingHttpClient;
import com.netflix.client.http.AsyncHttpClientBuilder;
import com.netflix.client.http.BufferedHttpResponseCallback;
import com.netflix.client.http.HttpRequest;
import com.netflix.client.http.HttpResponse;
import com.netflix.ribbon.examples.ExampleAppWithLocalResource;
import com.netflix.ribbon.examples.server.ServerResources;
import java.net.URI;
import java.util.concurrent.Future;

public class PostExample
extends ExampleAppWithLocalResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        AsyncBufferingHttpClient client = AsyncHttpClientBuilder.withApacheAsyncClient().buildBufferingClient();
        URI uri = new URI(this.SERVICE_URI + "testAsync/person");
        ServerResources.Person myPerson = new ServerResources.Person("Example", 5);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).verb(HttpRequest.Verb.POST).entity((Object)myPerson).header("Content-type", "application/json").build();
        try {
            Future response = client.execute((ClientRequest)request, (BufferedResponseCallback)new BufferedHttpResponseCallback(){

                public void failed(Throwable e) {
                    e.printStackTrace();
                }

                public void completed(HttpResponse response) {
                    try {
                        System.out.println("Person uploaded: " + response.getEntity(ServerResources.Person.class));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void cancelled() {
                }
            });
            response.get();
        }
        finally {
            client.close();
        }
    }

    public static void main(String[] args) throws Exception {
        PostExample app = new PostExample();
        app.runApp();
    }
}

