/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.proxy.processor;

import com.netflix.evcache.EVCacheTranscoder;
import com.netflix.ribbon.ResourceGroup;
import com.netflix.ribbon.RibbonResourceFactory;
import com.netflix.ribbon.evache.EvCacheOptions;
import com.netflix.ribbon.evache.EvCacheProvider;
import com.netflix.ribbon.proxy.ProxyAnnotationException;
import com.netflix.ribbon.proxy.Utils;
import com.netflix.ribbon.proxy.annotation.EvCache;
import com.netflix.ribbon.proxy.processor.AnnotationProcessor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class EVCacheAnnotationProcessor
implements AnnotationProcessor<ResourceGroup.GroupBuilder, ResourceGroup.TemplateBuilder> {
    private Map<CacheId, EvCacheProvider<?>> evCacheProviderPool = new HashMap();

    public void process(String templateName, ResourceGroup.TemplateBuilder templateBuilder, Method method) {
        EVCacheTranscoder transcoder;
        EvCache annotation = method.getAnnotation(EvCache.class);
        if (annotation == null) {
            return;
        }
        Class<? extends EVCacheTranscoder<?>>[] transcoderClasses = annotation.transcoder();
        if (transcoderClasses.length == 0) {
            transcoder = null;
        } else {
            if (transcoderClasses.length > 1) {
                throw new ProxyAnnotationException("Multiple transcoders defined on method " + method.getName());
            }
            transcoder = (EVCacheTranscoder)Utils.newInstance(transcoderClasses[0]);
        }
        EvCacheOptions evCacheOptions = new EvCacheOptions(annotation.appName(), annotation.name(), annotation.enableZoneFallback(), annotation.ttl(), transcoder, annotation.key());
        if (evCacheOptions != null) {
            CacheId cacheId = new CacheId(evCacheOptions.getAppName(), evCacheOptions.getCacheName());
            EvCacheProvider<Object> provider = this.evCacheProviderPool.get(cacheId);
            if (provider == null) {
                provider = new EvCacheProvider(evCacheOptions);
                this.evCacheProviderPool.put(cacheId, provider);
            }
            templateBuilder.withCacheProvider(evCacheOptions.getCacheKeyTemplate(), provider);
        }
    }

    public void process(String groupName, ResourceGroup.GroupBuilder groupBuilder, RibbonResourceFactory factory, Class<?> interfaceClass) {
    }

    private static final class CacheId {
        private final String appName;
        private final String cacheName;

        CacheId(String appName, String cacheName) {
            this.appName = appName;
            this.cacheName = cacheName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheId cacheId = (CacheId)o;
            if (!this.appName.equals(cacheId.appName)) {
                return false;
            }
            return this.cacheName.equals(cacheId.cacheName);
        }

        public int hashCode() {
            int result = this.appName.hashCode();
            result = 31 * result + this.cacheName.hashCode();
            return result;
        }
    }
}

