/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.niws.loadbalancer;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.config.ConfigurationManager;
import com.netflix.eureka2.Server;
import com.netflix.eureka2.client.EurekaInterestClient;
import com.netflix.eureka2.client.EurekaInterestClientBuilder;
import com.netflix.eureka2.client.Eurekas;
import com.netflix.eureka2.client.functions.InterestFunctions;
import com.netflix.eureka2.client.resolver.ServerResolver;
import com.netflix.eureka2.client.resolver.ServerResolvers;
import com.netflix.eureka2.eureka1.utils.Eureka1ModelConverters;
import com.netflix.eureka2.interests.Interest;
import com.netflix.eureka2.interests.Interests;
import com.netflix.eureka2.registry.instance.InstanceInfo;
import com.netflix.loadbalancer.AbstractServerList;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import com.netflix.niws.loadbalancer.Eureka2Clients;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;

public class Eureka2EnabledNIWSServerList
extends AbstractServerList<DiscoveryEnabledServer> {
    private static final Logger logger = LoggerFactory.getLogger(Eureka2EnabledNIWSServerList.class);
    public static final String EUREKA2_WRITE_CLUSTER_HOST = "eureka2.writeCluster.host";
    public static final CommonClientConfigKey<String> EUREKA2_WRITE_CLUSTER_HOST_KEY = new CommonClientConfigKey<String>("eureka2.writeCluster.host"){};
    public static final String EUREKA2_WRITE_CLUSTER_INTEREST_PORT = "eureka2.writeCluster.interestPort";
    public static final CommonClientConfigKey<Integer> EUREKA2_WRITE_CLUSTER_INTEREST_PORT_KEY = new CommonClientConfigKey<Integer>("eureka2.writeCluster.interestPort"){};
    public static final String EUREKA2_READ_CLUSTER_VIP = "eureka2.readCluster.vip";
    public static final CommonClientConfigKey<String> EUREKA2_READ_CLUSTER_VIP_KEY = new CommonClientConfigKey<String>("eureka2.readCluster.vip"){};
    public static final String EUREKA2_RESOLVE_TIMEOUT = "eureka2.resolveTimeout";
    public static final CommonClientConfigKey<Integer> EUREKA2_RESOLVE_TIMEOUT_KEY = new CommonClientConfigKey<Integer>("eureka2.resolveTimeout"){};
    public static final int DEFAULT_EUREKA2_RESOLVE_TIMEOUT = 30000;
    private IClientConfig clientConfig;
    private String clientName;
    private String[] vipAddresses;
    private boolean isSecure;
    private boolean prioritizeVipAddressBasedServers = true;
    private String datacenter;
    private int overridePort = 7001;
    private boolean shouldUseOverridePort;
    private boolean shouldUseIpAddr;
    private AtomicReference<ServerListReader> serverListReaderRef = new AtomicReference();

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.clientName = clientConfig.getClientName();
        String vipAddressesValue = clientConfig.resolveDeploymentContextbasedVipAddresses();
        if (vipAddressesValue == null && ConfigurationManager.getConfigInstance().getBoolean("DiscoveryEnabledNIWSServerList.failFastOnNullVip", true)) {
            throw new NullPointerException("VIP address for client " + this.clientName + " is null");
        }
        this.vipAddresses = vipAddressesValue.split(",");
        this.isSecure = clientConfig.getPropertyAsBoolean(CommonClientConfigKey.IsSecure, false);
        this.prioritizeVipAddressBasedServers = clientConfig.getPropertyAsBoolean(CommonClientConfigKey.PrioritizeVipAddressBasedServers, this.prioritizeVipAddressBasedServers);
        this.datacenter = ConfigurationManager.getDeploymentContext().getDeploymentDatacenter();
        this.shouldUseIpAddr = clientConfig.getPropertyAsBoolean(CommonClientConfigKey.UseIPAddrForServer, DefaultClientConfigImpl.DEFAULT_USEIPADDRESS_FOR_SERVER);
        if (clientConfig.getPropertyAsBoolean(CommonClientConfigKey.ForceClientPortConfiguration, false)) {
            if (this.isSecure) {
                if (clientConfig.containsProperty(CommonClientConfigKey.SecurePort)) {
                    this.overridePort = clientConfig.getPropertyAsInteger(CommonClientConfigKey.SecurePort, 7001);
                    this.shouldUseOverridePort = true;
                } else {
                    logger.warn(this.clientName + " set to force client port but no secure port is set, so ignoring");
                }
            } else if (clientConfig.containsProperty(CommonClientConfigKey.Port)) {
                this.overridePort = clientConfig.getPropertyAsInteger(CommonClientConfigKey.Port, 7001);
                this.shouldUseOverridePort = true;
            } else {
                logger.warn(this.clientName + " set to force client port but no port is set, so ignoring");
            }
        }
    }

    public List<DiscoveryEnabledServer> getInitialListOfServers() {
        return this.obtainServersViaEureka2();
    }

    public List<DiscoveryEnabledServer> getUpdatedListOfServers() {
        return this.obtainServersViaEureka2();
    }

    public void shutdown() {
        ServerListReader current = this.serverListReaderRef.getAndSet(null);
        if (current != null) {
            current.shutdown();
        }
    }

    private List<DiscoveryEnabledServer> obtainServersViaEureka2() {
        logger.info("Resolving {} from Eureka2...", (Object[])this.vipAddresses);
        List<com.netflix.appinfo.InstanceInfo> instanceInfos = this.getServerListReader().getLatestServerListOrWait();
        if (instanceInfos == null) {
            logger.warn("Server resolve for vip={},secure={} timed out", (Object)this.vipAddresses, (Object)this.isSecure);
            return Collections.emptyList();
        }
        return this.toServerList(instanceInfos);
    }

    private ServerListReader getServerListReader() {
        ServerListReader serverListReader;
        ServerListReader current = this.serverListReaderRef.get();
        if (current != null && current.isClosed()) {
            this.serverListReaderRef.compareAndSet(current, null);
            return this.getServerListReader();
        }
        if (current == null && !this.serverListReaderRef.compareAndSet(null, serverListReader = new ServerListReader(this.clientConfig, this.isSecure, this.vipAddresses))) {
            serverListReader.shutdown();
        }
        return this.serverListReaderRef.get();
    }

    private List<DiscoveryEnabledServer> toServerList(List<com.netflix.appinfo.InstanceInfo> listOfinstanceInfo) {
        ArrayList<DiscoveryEnabledServer> serverList = new ArrayList<DiscoveryEnabledServer>(listOfinstanceInfo.size());
        for (com.netflix.appinfo.InstanceInfo ii : listOfinstanceInfo) {
            if (ii.getStatus() != InstanceInfo.InstanceStatus.UP) continue;
            if (this.shouldUseOverridePort) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Overriding port on client name: " + this.clientName + " to " + this.overridePort);
                }
                com.netflix.appinfo.InstanceInfo copy = new com.netflix.appinfo.InstanceInfo(ii);
                ii = this.isSecure ? new InstanceInfo.Builder(copy).setSecurePort(this.overridePort).build() : new InstanceInfo.Builder(copy).setPort(this.overridePort).build();
            }
            DiscoveryEnabledServer des = new DiscoveryEnabledServer(ii, this.isSecure, this.shouldUseIpAddr);
            des.setZone(Eureka2EnabledNIWSServerList.resolveZone(ii));
            serverList.add(des);
        }
        return serverList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Eureka2EnabledNIWSServerList:");
        sb.append("; clientName:").append(this.clientName);
        sb.append("; Effective vipAddresses:").append(this.vipAddresses);
        sb.append("; isSecure:").append(this.isSecure);
        sb.append("; datacenter:").append(this.datacenter);
        return sb.toString();
    }

    private static String resolveZone(com.netflix.appinfo.InstanceInfo myInfo) {
        String awsInstanceZone;
        String instanceZone = "default";
        if (myInfo != null && myInfo.getDataCenterInfo().getName() == DataCenterInfo.Name.Amazon && (awsInstanceZone = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.availabilityZone)) != null) {
            instanceZone = awsInstanceZone;
        }
        return instanceZone;
    }

    static class ServerListReader {
        private final EurekaInterestClient interestClient;
        private final Subscription subscription;
        private final boolean singletonEureka2Client;
        private volatile boolean closed;
        private final int resolveTimeout;
        private final AtomicReference<List<com.netflix.appinfo.InstanceInfo>> latestServerList = new AtomicReference(Collections.emptyList());
        private final CountDownLatch firstBatchLatch = new CountDownLatch(1);

        ServerListReader(IClientConfig clientConfig, boolean isSecureVip, final String[] vipAddresses) {
            boolean bl = this.singletonEureka2Client = Eureka2Clients.getInterestClient() != null;
            if (this.singletonEureka2Client) {
                logger.info("Initializing Eureka2EnabledNIWSServerList with EurekaInterestClient provided by EurekaClients singleton");
                this.interestClient = Eureka2Clients.getInterestClient();
            } else {
                String writeClusterHost = clientConfig.getPropertyAsString(EUREKA2_WRITE_CLUSTER_HOST_KEY, null);
                int interestPort = clientConfig.getPropertyAsInteger(EUREKA2_WRITE_CLUSTER_INTEREST_PORT_KEY, 12103);
                String readClusterVip = clientConfig.getPropertyAsString(EUREKA2_READ_CLUSTER_VIP_KEY, null);
                logger.info("Initializing Eureka2EnabledNIWSServerList from IClientConfig (writeClusterHost={}, interestPort={}, readClusterVip={})", new Object[]{writeClusterHost, interestPort, readClusterVip});
                if (writeClusterHost == null) {
                    throw new IllegalArgumentException("Eureka2 write cluster address not configured");
                }
                if (readClusterVip == null) {
                    throw new IllegalArgumentException("Eureka2 read cluster VIP address not configured");
                }
                ServerResolver writeClusterResolver = writeClusterHost.indexOf(46) == -1 ? ServerResolvers.from((Server[])new Server[]{new Server(writeClusterHost, interestPort)}) : ServerResolvers.fromDnsName((String)writeClusterHost).withPort(interestPort);
                ServerResolver readClusterResolver = ServerResolvers.fromEureka((ServerResolver)writeClusterResolver).forInterest(Interests.forVips((String[])new String[]{readClusterVip}));
                this.interestClient = (EurekaInterestClient)((EurekaInterestClientBuilder)Eurekas.newInterestClientBuilder().withServerResolver(readClusterResolver)).build();
            }
            this.resolveTimeout = clientConfig.getPropertyAsInteger(EUREKA2_RESOLVE_TIMEOUT_KEY, 30000);
            Interest interest = isSecureVip ? Interests.forSecureVips((String[])vipAddresses) : Interests.forVips((String[])vipAddresses);
            this.subscription = this.interestClient.forInterest(interest).compose(InterestFunctions.buffers()).compose(InterestFunctions.snapshots()).doOnNext((Action1)new Action1<LinkedHashSet<InstanceInfo>>(){

                public void call(LinkedHashSet<InstanceInfo> instanceInfos) {
                    if (!instanceInfos.isEmpty()) {
                        ServerListReader.this.latestServerList.set(Eureka1ModelConverters.toEureka1xInstanceInfos(instanceInfos));
                        ServerListReader.this.firstBatchLatch.countDown();
                    }
                }
            }).doOnError((Action1)new Action1<Throwable>(){

                public void call(Throwable e) {
                    logger.error("Cannot resolve servers for vip addresses " + Arrays.toString(vipAddresses), e);
                }
            }).doOnTerminate(new Action0(){

                public void call() {
                    ServerListReader.this.shutdown();
                }
            }).subscribe();
        }

        boolean isClosed() {
            return this.closed;
        }

        List<com.netflix.appinfo.InstanceInfo> getLatestServerListOrWait() {
            try {
                this.firstBatchLatch.await(this.resolveTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.latestServerList.get();
        }

        void shutdown() {
            this.subscription.unsubscribe();
            if (!this.singletonEureka2Client) {
                this.interestClient.shutdown();
            }
            this.closed = true;
        }
    }
}

