/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client.config;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.client.config.Property;
import com.netflix.client.config.PropertyResolver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReloadableClientConfig
implements IClientConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ReloadableClientConfig.class);
    private static final String DEFAULT_CLIENT_NAME = "";
    private static final String DEFAULT_NAMESPACE = "ribbon";
    private final Map<String, Object> defaultProperties = new HashMap<String, Object>();
    private final Map<IClientConfigKey, ReloadableProperty<?>> dynamicProperties = new ConcurrentHashMap();
    private final List<Runnable> changeActions = new CopyOnWriteArrayList<Runnable>();
    private final AtomicLong refreshCounter = new AtomicLong();
    private final PropertyResolver resolver;
    private String clientName;
    private String namespace = "ribbon";
    private boolean isDynamic;
    private volatile String cachedToString = null;

    protected ReloadableClientConfig(PropertyResolver resolver) {
        this(resolver, DEFAULT_CLIENT_NAME);
        this.isDynamic = false;
    }

    protected ReloadableClientConfig(PropertyResolver resolver, String clientName) {
        this.clientName = clientName;
        this.isDynamic = true;
        this.resolver = resolver;
        resolver.onChange(this::reload);
    }

    public final void reload() {
        this.changeActions.forEach(Runnable::run);
        this.cachedToString = null;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Override
    public final String getClientName() {
        return this.clientName;
    }

    @Override
    public String getNameSpace() {
        return this.namespace;
    }

    @Override
    public final void setNameSpace(String nameSpace) {
        this.namespace = nameSpace;
    }

    @Override
    public void loadProperties(String clientName) {
        this.isDynamic = true;
        this.clientName = clientName;
    }

    @Override
    public void loadDefaultValues() {
        this.isDynamic = true;
    }

    @Override
    public final Map<String, Object> getProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.dynamicProperties.size());
        this.dynamicProperties.forEach((? super K key, ? super V prop) -> prop.getOptional().ifPresent(value -> result.put(key.key(), value.toString())));
        LOG.info(((Object)result).toString());
        return result;
    }

    @Override
    public void forEachDefault(BiConsumer<IClientConfigKey<?>, Object> consumer) {
        this.dynamicProperties.forEach((? super K key, ? super V value) -> consumer.accept((IClientConfigKey<?>)key, this.defaultProperties.get(key.key())));
    }

    @Override
    public void forEach(BiConsumer<IClientConfigKey<?>, Object> consumer) {
        this.dynamicProperties.forEach((? super K key, ? super V value) -> consumer.accept((IClientConfigKey<?>)key, value.get()));
    }

    private <T> ReloadableProperty<T> createProperty(final Supplier<Optional<T>> valueSupplier, final Supplier<T> defaultValue, final boolean isDynamic) {
        Preconditions.checkNotNull(valueSupplier, (Object)"defaultValueSupplier cannot be null");
        return new ReloadableProperty<T>(){
            private volatile Optional<T> value = Optional.empty();
            {
                this.refresh();
                if (isDynamic) {
                    ReloadableClientConfig.this.changeActions.add(this::refresh);
                }
            }

            @Override
            public void onChange(Consumer<T> consumer) {
                AtomicReference previous = new AtomicReference(this.getOptional());
                ReloadableClientConfig.this.changeActions.add(() -> this.lambda$onChange$0(previous, consumer, (Supplier)defaultValue));
            }

            @Override
            public T get() {
                return this.value.orElseGet(defaultValue);
            }

            @Override
            public Optional<T> getOptional() {
                return this.value;
            }

            @Override
            public void refresh() {
                ReloadableClientConfig.this.refreshCounter.incrementAndGet();
                this.value = (Optional)valueSupplier.get();
            }

            public String toString() {
                return String.valueOf(this.get());
            }

            private /* synthetic */ void lambda$onChange$0(AtomicReference previous, Consumer consumer, Supplier defaultValue2) {
                Optional current = this.getOptional();
                if (!current.equals(Optional.ofNullable(previous.get()))) {
                    previous.set(current);
                    consumer.accept(current.orElseGet(defaultValue2));
                }
            }
        };
    }

    @Override
    public final <T> T get(IClientConfigKey<T> key) {
        return Optional.ofNullable(this.getInternal(key)).flatMap(Property::getOptional).orElse(null);
    }

    public final <T> ReloadableProperty<T> getInternal(IClientConfigKey<T> key) {
        return this.dynamicProperties.computeIfAbsent(key, ignore -> this.getClientDynamicProperty(key, this.isDynamic));
    }

    @Override
    public final <T> Property<T> getGlobalProperty(IClientConfigKey<T> key) {
        LOG.debug("Get global property {} default {}", (Object)key.key(), key.defaultValue());
        return this.createProperty(() -> this.resolver.get(key.key(), key.type()), key::defaultValue, true);
    }

    private <T> ReloadableProperty<T> getClientDynamicProperty(IClientConfigKey<T> key, boolean isDynamic) {
        LOG.debug("Get dynamic property key={} ns={} client={}", new Object[]{key.key(), this.getNameSpace(), this.clientName});
        return this.createProperty(() -> this.resolveFinalProperty(key), key::defaultValue, isDynamic);
    }

    private <T> Optional<T> resolveFinalProperty(IClientConfigKey<T> key) {
        Optional<T> value;
        if (!StringUtils.isEmpty((String)this.clientName) && (value = this.resolver.get(this.clientName + "." + this.getNameSpace() + "." + key.key(), key.type())).isPresent()) {
            return value;
        }
        value = this.resolver.get(this.getNameSpace() + "." + key.key(), key.type());
        if (value.isPresent()) {
            return value;
        }
        value = this.resolveDefaultProperty(key);
        if (value.isPresent()) {
            return value;
        }
        return Optional.empty();
    }

    protected <T> Optional<T> resolveDefaultProperty(IClientConfigKey<T> key) {
        return Optional.ofNullable(this.defaultProperties.get(key.key())).map(value -> {
            Class type = key.type();
            if (!value.getClass().equals(type)) {
                try {
                    if (type.equals(String.class)) {
                        return value.toString();
                    }
                    if (value.getClass().equals(String.class)) {
                        String strValue = (String)value;
                        if (Integer.class.equals(type)) {
                            return Integer.valueOf(strValue);
                        }
                        if (Boolean.class.equals(type)) {
                            return Boolean.valueOf(strValue);
                        }
                        if (Float.class.equals(type)) {
                            return Float.valueOf(strValue);
                        }
                        if (Long.class.equals(type)) {
                            return Long.valueOf(strValue);
                        }
                        if (Double.class.equals(type)) {
                            return Double.valueOf(strValue);
                        }
                        if (TimeUnit.class.equals(type)) {
                            return TimeUnit.valueOf(strValue);
                        }
                        return PropertyResolver.resolveWithValueOf(type, strValue).orElseThrow(() -> new IllegalArgumentException("Unsupported value type `" + type + "'"));
                    }
                    throw new IllegalArgumentException("Incompatible value type `" + value.getClass() + "` while expecting '" + type + "`");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Error parsing value '" + value + "' for '" + key.key() + "'", e);
                }
            }
            return value;
        });
    }

    @Override
    public final <T> Property<T> getDynamicProperty(IClientConfigKey<T> key) {
        return this.getClientDynamicProperty(key, true);
    }

    @Override
    public final <T> T get(IClientConfigKey<T> key, T defaultValue) {
        return Optional.ofNullable(this.get(key)).orElse(defaultValue);
    }

    @Override
    public final <T> IClientConfig set(IClientConfigKey<T> key, T value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key cannot be null");
        if (value == null) {
            this.defaultProperties.remove(key.key());
        } else {
            this.defaultProperties.put(key.key(), value);
        }
        this.getInternal(key).refresh();
        this.cachedToString = null;
        return this;
    }

    @Override
    @Deprecated
    public void setProperty(IClientConfigKey key, Object value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Value may not be null");
        this.set(key, value);
    }

    @Override
    @Deprecated
    public Object getProperty(IClientConfigKey key) {
        return this.getInternal(key).get();
    }

    @Override
    @Deprecated
    public Object getProperty(IClientConfigKey key, Object defaultVal) {
        return Optional.ofNullable(this.getInternal(key).get()).orElse(defaultVal);
    }

    @Override
    @Deprecated
    public boolean containsProperty(IClientConfigKey key) {
        return this.dynamicProperties.containsKey(key.key());
    }

    @Override
    @Deprecated
    public int getPropertyAsInteger(IClientConfigKey key, int defaultValue) {
        return Optional.ofNullable(this.getProperty(key)).map(Integer.class::cast).orElse(defaultValue);
    }

    @Override
    @Deprecated
    public String getPropertyAsString(IClientConfigKey key, String defaultValue) {
        return Optional.ofNullable(this.getProperty(key)).map(Object::toString).orElse(defaultValue);
    }

    @Override
    @Deprecated
    public boolean getPropertyAsBoolean(IClientConfigKey key, boolean defaultValue) {
        return Optional.ofNullable(this.getProperty(key)).map(Boolean.class::cast).orElse(defaultValue);
    }

    public IClientConfig applyOverride(IClientConfig override) {
        if (override == null) {
            return this;
        }
        this.defaultProperties.putAll(override.getProperties());
        this.reload();
        return this;
    }

    public String toString() {
        if (this.cachedToString == null) {
            String newToString;
            this.cachedToString = newToString = this.generateToString();
            return newToString;
        }
        return this.cachedToString;
    }

    public long getRefreshCount() {
        return this.refreshCounter.get();
    }

    private String generateToString() {
        return "ClientConfig:" + this.dynamicProperties.entrySet().stream().map(t -> {
            if (((IClientConfigKey)t.getKey()).key().endsWith("Password")) {
                return t.getKey() + ":***";
            }
            Object value = ((ReloadableProperty)t.getValue()).get();
            Object defaultValue = ((IClientConfigKey)t.getKey()).defaultValue();
            return t.getKey() + ":" + MoreObjects.firstNonNull(value, defaultValue);
        }).collect(Collectors.joining(", "));
    }

    static interface ReloadableProperty<T>
    extends Property<T> {
        public void refresh();
    }
}

