/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client.config;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PropertyResolver {
    public static final Logger LOG = LoggerFactory.getLogger(PropertyResolver.class);
    public static final Map<Class<?>, Optional<Method>> valueOfMethods = new ConcurrentHashMap();

    public <T> Optional<T> get(String var1, Class<T> var2);

    public void onChange(Runnable var1);

    public static <T> Optional<T> resolveWithValueOf(Class<T> type, String value) {
        return valueOfMethods.computeIfAbsent(type, ignore -> {
            try {
                return Optional.of(type.getDeclaredMethod("valueOf", String.class));
            }
            catch (NoSuchMethodException e) {
                return Optional.empty();
            }
            catch (Exception e) {
                LOG.warn("Unable to determine if type " + type + " has a valueOf() static method", (Throwable)e);
                return Optional.empty();
            }
        }).map(method -> {
            try {
                return method.invoke(null, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }
}

