/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client.config;

import com.netflix.client.config.CommonClientConfigKey;

public interface IClientConfigKey<T> {
    public String key();

    public Class<T> type();

    default public T defaultValue() {
        return null;
    }

    default public IClientConfigKey<T> format(Object ... args) {
        return this.create(String.format(this.key(), args), this.type(), this.defaultValue());
    }

    default public IClientConfigKey<T> create(final String key, final Class<T> type, final T defaultValue) {
        return new IClientConfigKey<T>(){

            public int hashCode() {
                return this.key().hashCode();
            }

            public boolean equals(Object obj) {
                if (obj instanceof IClientConfigKey) {
                    return this.key().equals(((IClientConfigKey)obj).key());
                }
                return false;
            }

            public String toString() {
                return this.key();
            }

            @Override
            public String key() {
                return key;
            }

            @Override
            public Class<T> type() {
                return type;
            }

            @Override
            public T defaultValue() {
                return defaultValue;
            }
        };
    }

    public static final class Keys
    extends CommonClientConfigKey {
        private Keys(String configKey) {
            super(configKey);
        }
    }
}

